/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlPatternTest {
    @Test
    public void matchesExactUrlWithQuery() {
        UrlPattern urlPattern = WireMock.urlEqualTo((String)"/my/exact/url?one=1&two=2&three=3333333");
        Assertions.assertTrue((boolean)urlPattern.match("/my/exact/url?one=1&two=2&three=3333333").isExactMatch());
        Assertions.assertFalse((boolean)urlPattern.match("/my/wrong/url?one=1&three=3333333").isExactMatch());
    }

    @Test
    public void matchesOnRegexWithQuery() {
        UrlPattern urlPattern = WireMock.urlMatching((String)"/my/([a-z]*)/url\\?one=1&two=([0-9]*)&three=3333333");
        Assertions.assertTrue((boolean)urlPattern.match("/my/regex/url?one=1&two=123456&three=3333333").isExactMatch());
        Assertions.assertFalse((boolean)urlPattern.match("/my/BAD/url?one=1&two=123456&three=3333333").isExactMatch());
    }

    @Test
    public void matchesExactlyOnPathOnly() {
        UrlPathPattern urlPathPattern = WireMock.urlPathEqualTo((String)"/the/exact/path");
        Assertions.assertTrue((boolean)urlPathPattern.match("/the/exact/path").isExactMatch());
        Assertions.assertFalse((boolean)urlPathPattern.match("/totally/incorrect/path").isExactMatch());
    }

    @Test
    public void matchesOnPathWithRegex() {
        UrlPathPattern urlPathPattern = WireMock.urlPathMatching((String)"/my/([a-z]*)/path");
        Assertions.assertTrue((boolean)urlPathPattern.match("/my/regex/path?one=not_looked_at").isExactMatch());
        Assertions.assertFalse((boolean)urlPathPattern.match("/my/12345/path").isExactMatch());
    }

    @Test
    public void noMatchOnNullValueForUrlEquality() {
        MatcherAssert.assertThat((Object)WireMock.urlEqualTo((String)"/things").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void noMatchOnNullValueForUrlPathEquality() {
        MatcherAssert.assertThat((Object)WireMock.urlPathEqualTo((String)"/things").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void noMatchOnNullValueForUrlRegex() {
        MatcherAssert.assertThat((Object)WireMock.urlMatching((String)"/things/.*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void noMatchOnNullValueForUrlPathRegex() {
        MatcherAssert.assertThat((Object)WireMock.urlPathMatching((String)"/things/.*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }
}

