/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class SnapshotRecordResultDeserialiserTest {
    @Test
    public void supportsFullResponse() {
        SnapshotRecordResult result = (SnapshotRecordResult)Json.read((String)"{                                     \n    \"mappings\": [                    \n        {                              \n            \"request\": {             \n                \"url\": \"/hello\",   \n                \"method\": \"GET\"    \n            },                         \n            \"response\": {            \n                \"status\": 201        \n            }                          \n        },                             \n        {}                             \n    ]                                  \n}", SnapshotRecordResult.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(SnapshotRecordResult.Full.class));
        MatcherAssert.assertThat((Object)result.getStubMappings().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(result.getStubMappings().get(0), (Matcher)Matchers.instanceOf(StubMapping.class));
    }

    @Test
    public void supportsIdsOnlyResponse() {
        SnapshotRecordResult result = (SnapshotRecordResult)Json.read((String)"{                                                     \n    \"ids\": [                                         \n        \"d3f32721-ab5e-479c-9f7a-fda76ed5d803\",      \n        \"162d0567-4baf-408b-ad7f-41a779638082\",      \n        \"02ee46c3-0b49-40ca-a424-8298c099b6db\"       \n    ]                                                  \n}", SnapshotRecordResult.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(SnapshotRecordResult.Ids.class));
        SnapshotRecordResult.Ids idsResult = (SnapshotRecordResult.Ids)result;
        MatcherAssert.assertThat((Object)idsResult.getIds().size(), (Matcher)Matchers.is((Object)3));
    }
}

