/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.NotWritableException;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class JsonFileMappingsSourceTest {
    @TempDir
    public File tempDir;
    InMemoryStubMappings stubMappings;
    JsonFileMappingsSource source;
    File stubMappingFile;

    @BeforeEach
    public void init() throws Exception {
        this.stubMappings = new InMemoryStubMappings();
    }

    private void configureWithMultipleMappingFile() throws Exception {
        this.stubMappingFile = File.createTempFile("multi", ".json", this.tempDir);
        Files.copy((File)new File(TestFiles.filePath("multi-stub/multi.json")), (File)this.stubMappingFile);
        this.load();
    }

    private void configureWithSingleMappingFile() throws Exception {
        this.stubMappingFile = File.createTempFile("single", ".json", this.tempDir);
        Files.copy((File)new File(TestFiles.filePath("multi-stub/single.json")), (File)this.stubMappingFile);
        this.load();
    }

    private void load() {
        this.source = new JsonFileMappingsSource((FileSource)new SingleRootFileSource(this.tempDir));
        this.source.loadMappingsInto((StubMappings)this.stubMappings);
    }

    @Test
    public void loadsMappingsViaClasspathFileSource() {
        ClasspathFileSource fileSource = new ClasspathFileSource("jar-filesource");
        JsonFileMappingsSource source = new JsonFileMappingsSource((FileSource)fileSource);
        InMemoryStubMappings stubMappings = new InMemoryStubMappings();
        source.loadMappingsInto((StubMappings)stubMappings);
        List allMappings = stubMappings.getAll();
        MatcherAssert.assertThat((Object)allMappings, (Matcher)Matchers.hasSize((int)2));
        List<String> mappingRequestUrls = Arrays.asList(((StubMapping)allMappings.get(0)).getRequest().getUrl(), ((StubMapping)allMappings.get(1)).getRequest().getUrl());
        MatcherAssert.assertThat(mappingRequestUrls, (Matcher)Matchers.is(Arrays.asList("/second_test", "/test")));
    }

    @Test
    public void stubMappingFilesAreWrittenWithInsertionIndex() throws Exception {
        JsonFileMappingsSource source = new JsonFileMappingsSource((FileSource)new SingleRootFileSource(this.tempDir));
        StubMapping stub = WireMock.get((String)"/saveable").willReturn(WireMock.ok()).build();
        source.save(stub);
        File savedFile = this.tempDir.listFiles()[0];
        String savedStub = FileUtils.readFileToString((File)savedFile, (Charset)Charsets.UTF_8);
        MatcherAssert.assertThat((Object)savedStub, (Matcher)Matchers.containsString((String)"\"insertionIndex\" : 0"));
    }

    @Test
    public void refusesToRemoveStubMappingContainedInMultiFile() throws Exception {
        this.configureWithMultipleMappingFile();
        StubMapping firstStub = (StubMapping)this.stubMappings.getAll().get(0);
        try {
            this.source.remove(firstStub);
            Assertions.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotWritableException.class));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Stubs loaded from multi-mapping files are read-only, and therefore cannot be removed"));
        }
        MatcherAssert.assertThat((Object)this.stubMappingFile.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void refusesToRemoveAllWhenMultiMappingFilesArePresent() throws Exception {
        this.configureWithMultipleMappingFile();
        try {
            this.source.removeAll();
            Assertions.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotWritableException.class));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Some stubs were loaded from multi-mapping files which are read-only, so remove all cannot be performed"));
        }
        MatcherAssert.assertThat((Object)this.stubMappingFile.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void refusesToSaveStubMappingOriginallyLoadedFromMultiMappingFile() throws Exception {
        this.configureWithMultipleMappingFile();
        StubMapping firstStub = (StubMapping)this.stubMappings.getAll().get(0);
        try {
            this.source.save(firstStub);
            Assertions.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotWritableException.class));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Stubs loaded from multi-mapping files are read-only, and therefore cannot be saved"));
        }
        MatcherAssert.assertThat((Object)this.stubMappingFile.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void savesStubMappingOriginallyLoadedFromSingleMappingFile() throws Exception {
        this.configureWithSingleMappingFile();
        StubMapping firstStub = (StubMapping)this.stubMappings.getAll().get(0);
        firstStub.setName("New name");
        this.source.save(firstStub);
        MatcherAssert.assertThat((Object)FileUtils.readFileToString((File)this.stubMappingFile, (Charset)Charsets.UTF_8), (Matcher)Matchers.containsString((String)"New name"));
    }

    @Test
    public void removesStubMappingOriginallyLoadedFromSingleMappingFile() throws Exception {
        this.configureWithSingleMappingFile();
        StubMapping firstStub = (StubMapping)this.stubMappings.getAll().get(0);
        this.source.remove(firstStub);
        MatcherAssert.assertThat((Object)this.stubMappingFile.exists(), (Matcher)Matchers.is((Object)false));
    }
}

