/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.testsupport.MockHttpResponder;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AdminRequestHandlerTest {
    private Admin admin = (Admin)Mockito.mock(Admin.class);
    private MockHttpResponder httpResponder;
    private AdminRequestHandler handler;
    private static final String REQUEST_PATTERN_SAMPLE = "{\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"method\": \"DELETE\",\t\t\t\t\t\t\n\t\"url\": \"/some/resource\"\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String GLOBAL_SETTINGS_JSON = "{\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"fixedDelay\": 2000\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t";

    @BeforeEach
    public void init() {
        this.httpResponder = new MockHttpResponder();
        this.handler = new AdminRequestHandler(AdminRoutes.defaults(), this.admin, (ResponseRenderer)new BasicResponseRenderer(), (Authenticator)new NoAuthenticator(), false, Collections.emptyList(), new DataTruncationSettings(Limit.UNLIMITED));
    }

    @Test
    public void shouldSaveMappingsWhenSaveCalled() {
        Request request = MockRequestBuilder.aRequest().withUrl("/mappings/save").withMethod(RequestMethod.POST).build();
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        ((Admin)Mockito.verify((Object)this.admin)).saveMappings();
    }

    @Test
    public void shouldClearMappingsJournalAndRequestDelayWhenResetCalled() {
        Request request = MockRequestBuilder.aRequest().withUrl("/reset").withMethod(RequestMethod.POST).build();
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        ((Admin)Mockito.verify((Object)this.admin)).resetAll();
    }

    @Test
    public void shouldClearJournalWhenResetRequestsCalled() {
        Request request = MockRequestBuilder.aRequest().withUrl("/requests/reset").withMethod(RequestMethod.POST).build();
        this.handler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        ((Admin)Mockito.verify((Object)this.admin)).resetRequests();
    }

    @Test
    public void shouldReturnCountOfMatchingRequests() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.DELETE, (UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).build();
        Mockito.when((Object)this.admin.countRequestsMatching(requestPattern)).thenReturn((Object)VerificationResult.withCount((int)5));
        this.handler.handle(MockRequestBuilder.aRequest().withUrl("/requests/count").withMethod(RequestMethod.POST).withBody(REQUEST_PATTERN_SAMPLE).build(), (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), WireMatchers.equalToJson("{ \"count\": 5, \"requestJournalDisabled\" : false}"));
    }

    @Test
    public void shouldUpdateGlobalSettings() {
        this.handler.handle(MockRequestBuilder.aRequest().withUrl("/settings").withMethod(RequestMethod.POST).withBody(GLOBAL_SETTINGS_JSON).build(), (HttpResponder)this.httpResponder);
        GlobalSettings expectedSettings = GlobalSettings.builder().fixedDelay(Integer.valueOf(2000)).build();
        ((Admin)Mockito.verify((Object)this.admin)).updateGlobalSettings(expectedSettings);
    }
}

