/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InMemoryMappingsTest {
    private InMemoryStubMappings mappings;

    @BeforeEach
    public void init() {
        this.mappings = new InMemoryStubMappings();
    }

    @AfterEach
    public void cleanUp() {
        LocalNotifier.set(null);
    }

    @Test
    public void correctlyAcceptsMappingAndReturnsCorrespondingResponse() {
        this.mappings.addMapping(new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).build(), new ResponseDefinition(204, "")));
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.PUT).withUrl("/some/resource").build();
        ResponseDefinition response = this.mappings.serveFor(request).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void returnsNotFoundWhenMethodIncorrect() {
        this.mappings.addMapping(new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).build(), new ResponseDefinition(204, "")));
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.POST).withUrl("/some/resource").build();
        ResponseDefinition response = this.mappings.serveFor(request).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void returnsNotFoundWhenUrlIncorrect() {
        this.mappings.addMapping(new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/some/resource")).build(), new ResponseDefinition(204, "")));
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.PUT).withUrl("/some/bad/resource").build();
        ResponseDefinition response = this.mappings.serveFor(request).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void returnsNotConfiguredResponseForUnmappedRequest() {
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.OPTIONS).withUrl("/not/mapped").build();
        ResponseDefinition response = this.mappings.serveFor(request).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.wasConfigured(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsMostRecentlyInsertedResponseIfTwoOrMoreMatch() {
        this.mappings.addMapping(new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/duplicated/resource")).build(), new ResponseDefinition(204, "Some content")));
        this.mappings.addMapping(new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/duplicated/resource")).build(), new ResponseDefinition(201, "Desired content")));
        ResponseDefinition response = this.mappings.serveFor(MockRequestBuilder.aRequest().withMethod(RequestMethod.GET).withUrl("/duplicated/resource").build()).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)201));
        MatcherAssert.assertThat((Object)response.getBody(), (Matcher)Matchers.is((Object)"Desired content"));
    }

    @Test
    public void returnsMappingInScenarioOnlyWhenStateIsCorrect() {
        StubMapping firstGetMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(204, "Initial content"));
        firstGetMapping.setScenarioName("TestScenario");
        firstGetMapping.setRequiredScenarioState("Started");
        this.mappings.addMapping(firstGetMapping);
        StubMapping putMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(204, ""));
        putMapping.setScenarioName("TestScenario");
        putMapping.setRequiredScenarioState("Started");
        putMapping.setNewScenarioState("Modified");
        this.mappings.addMapping(putMapping);
        StubMapping secondGetMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(204, "Modified content"));
        secondGetMapping.setScenarioName("TestScenario");
        secondGetMapping.setRequiredScenarioState("Modified");
        this.mappings.addMapping(secondGetMapping);
        Request firstGet = MockRequestBuilder.aRequest("firstGet").withMethod(RequestMethod.GET).withUrl("/scenario/resource").build();
        Request put = MockRequestBuilder.aRequest("put").withMethod(RequestMethod.PUT).withUrl("/scenario/resource").build();
        Request secondGet = MockRequestBuilder.aRequest("secondGet").withMethod(RequestMethod.GET).withUrl("/scenario/resource").build();
        MatcherAssert.assertThat((Object)this.mappings.serveFor(firstGet).getResponseDefinition().getBody(), (Matcher)Matchers.is((Object)"Initial content"));
        this.mappings.serveFor(put);
        MatcherAssert.assertThat((Object)this.mappings.serveFor(secondGet).getResponseDefinition().getBody(), (Matcher)Matchers.is((Object)"Modified content"));
    }

    @Test
    public void returnsMappingInScenarioWithNoRequiredState() {
        StubMapping firstGetMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(200, "Expected content"));
        firstGetMapping.setScenarioName("TestScenario");
        this.mappings.addMapping(firstGetMapping);
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.GET).withUrl("/scenario/resource").build();
        MatcherAssert.assertThat((Object)this.mappings.serveFor(request).getResponseDefinition().getBody(), (Matcher)Matchers.is((Object)"Expected content"));
    }

    @Test
    public void supportsResetOfAllScenariosState() {
        StubMapping firstGetMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(204, "Desired content"));
        firstGetMapping.setScenarioName("TestScenario");
        firstGetMapping.setRequiredScenarioState("Started");
        this.mappings.addMapping(firstGetMapping);
        StubMapping putMapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(204, ""));
        putMapping.setScenarioName("TestScenario");
        putMapping.setRequiredScenarioState("Started");
        putMapping.setNewScenarioState("Modified");
        this.mappings.addMapping(putMapping);
        this.mappings.serveFor(MockRequestBuilder.aRequest("put /scenario/resource").withMethod(RequestMethod.PUT).withUrl("/scenario/resource").build());
        ResponseDefinition response = this.mappings.serveFor(MockRequestBuilder.aRequest("1st get /scenario/resource").withMethod(RequestMethod.GET).withUrl("/scenario/resource").build()).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.wasConfigured(), (Matcher)Matchers.is((Object)false));
        this.mappings.resetScenarios();
        response = this.mappings.serveFor(MockRequestBuilder.aRequest("2nd get /scenario/resource").withMethod(RequestMethod.GET).withUrl("/scenario/resource").build()).getResponseDefinition();
        MatcherAssert.assertThat((Object)response.getBody(), (Matcher)Matchers.is((Object)"Desired content"));
    }

    @Test
    public void scenariosShouldBeResetWhenMappingsAreReset() {
        StubMapping firstMapping = this.aBasicMappingInScenario("Starting content");
        firstMapping.setRequiredScenarioState("Started");
        firstMapping.setNewScenarioState("modified");
        this.mappings.addMapping(firstMapping);
        StubMapping secondMapping = this.aBasicMappingInScenario("Modified content");
        secondMapping.setRequiredScenarioState("modified");
        this.mappings.addMapping(secondMapping);
        Request request = MockRequestBuilder.aRequest().withMethod(RequestMethod.POST).withUrl("/scenario/resource").build();
        this.mappings.serveFor(request);
        MatcherAssert.assertThat((Object)this.mappings.serveFor(request).getResponseDefinition().getBody(), (Matcher)Matchers.is((Object)"Modified content"));
        this.mappings.reset();
        StubMapping thirdMapping = this.aBasicMappingInScenario("Starting content");
        thirdMapping.setRequiredScenarioState("Started");
        this.mappings.addMapping(thirdMapping);
        MatcherAssert.assertThat((Object)this.mappings.serveFor(request).getResponseDefinition().getBody(), (Matcher)Matchers.is((Object)"Starting content"));
    }

    private StubMapping aBasicMappingInScenario(String body) {
        StubMapping mapping = new StubMapping(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlEqualTo((String)"/scenario/resource")).build(), new ResponseDefinition(200, body));
        mapping.setScenarioName("TestScenario");
        return mapping;
    }
}

