/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InMemoryStubMappingsTest {
    private InMemoryStubMappings inMemoryStubMappings;

    @BeforeEach
    public void setUp() throws Exception {
        this.inMemoryStubMappings = new InMemoryStubMappings();
    }

    @Test
    public void testEditMapping() throws Exception {
        StubMapping existingMapping = this.aMapping(1, "/priority1/1");
        this.inMemoryStubMappings.addMapping(existingMapping);
        StubMapping newMapping = this.aMapping(1, "/priority1/2");
        newMapping.setUuid(existingMapping.getUuid());
        this.inMemoryStubMappings.editMapping(newMapping);
        List allMappings = this.inMemoryStubMappings.getAll();
        MatcherAssert.assertThat((Object)allMappings, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(allMappings.get(0), (Matcher)Matchers.is((Object)newMapping));
        MatcherAssert.assertThat((Object)newMapping.getInsertionIndex(), (Matcher)Matchers.is((Object)existingMapping.getInsertionIndex()));
    }

    @Test
    public void testRemoveMapping() throws Exception {
        List allMappings = this.inMemoryStubMappings.getAll();
        MatcherAssert.assertThat((Object)allMappings, (Matcher)Matchers.hasSize((int)0));
        StubMapping existingMapping = this.aMapping(1, "priority1/1");
        this.inMemoryStubMappings.addMapping(existingMapping);
        StubMapping mappingToRemove = existingMapping = this.aMapping(2, "priority2/2");
        this.inMemoryStubMappings.addMapping(existingMapping);
        existingMapping = this.aMapping(3, "priority3/3");
        this.inMemoryStubMappings.addMapping(existingMapping);
        allMappings = this.inMemoryStubMappings.getAll();
        MatcherAssert.assertThat((Object)allMappings, (Matcher)Matchers.hasSize((int)3));
        this.inMemoryStubMappings.removeMapping(mappingToRemove);
        allMappings = this.inMemoryStubMappings.getAll();
        MatcherAssert.assertThat((Object)allMappings, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testEditMappingNotPresent() throws Exception {
        StubMapping existingMapping = this.aMapping(1, "/priority1/1");
        this.inMemoryStubMappings.addMapping(existingMapping);
        StubMapping newMapping = this.aMapping(1, "/priority1/2");
        try {
            this.inMemoryStubMappings.editMapping(newMapping);
            Assertions.fail((String)"Expected Exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)newMapping.getUuid().toString()));
        }
    }

    private StubMapping aMapping(Integer priority, String url) {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)url)).build();
        StubMapping mapping = new StubMapping(requestPattern, new ResponseDefinition());
        mapping.setPriority(priority);
        return mapping;
    }
}

