/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class ResponseDefinitionTest {
    private static final String STRING_BODY = "{\t        \t\t\t\t\t\t\t\t\n\t\t\"status\": 200,    \t\t\t\t\n\t\t\"body\": \"String content\" \t\t\n}\t\t\t\t\t\t\t\t\t\t\t";
    private static final String JSON_BODY = "{\t        \t\t\t\t\t\t\t\t\n\t\t\"status\": 200,    \t\t\t\t\n\t\t\"jsonBody\": {\"name\":\"wirmock\",\"isCool\":true} \n}\t\t\t\t\t\t\t\t\t\t\t";
    private static final byte[] BODY = new byte[]{1, 2, 3};
    private static final String BASE64_BODY = "AQID";
    private static final String BINARY_BODY = "{\t        \t\t\t\t\t\t\t\t        \n\t\t\"status\": 200,    \t\t\t\t        \n\t\t\"base64Body\": \"AQID\"     \n}\t\t\t\t\t\t\t\t\t\t\t        ";

    @Test
    public void copyProducesEqualObject() {
        ResponseDefinition response = new ResponseDefinition(222, null, "blah", null, null, "name.json", new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"thing", (String[])new String[]{"thingvalue"})}), null, Integer.valueOf(1112), null, null, "http://base.com", null, Fault.EMPTY_RESPONSE, (List)ImmutableList.of((Object)"transformer-1"), Parameters.one((String)"name", (Object)"Jeff"), Boolean.valueOf(true));
        ResponseDefinition copiedResponse = ResponseDefinition.copyOf((ResponseDefinition)response);
        Assertions.assertTrue((boolean)response.equals((Object)copiedResponse));
    }

    @Test
    public void copyPreservesConfiguredFlag() {
        ResponseDefinition response = ResponseDefinition.notConfigured();
        ResponseDefinition copiedResponse = ResponseDefinition.copyOf((ResponseDefinition)response);
        Assertions.assertFalse((boolean)copiedResponse.wasConfigured(), (String)"Should be not configured");
    }

    @Test
    public void correctlyUnmarshalsFromJsonWhenBodyIsAString() {
        ResponseDefinition responseDef = (ResponseDefinition)Json.read((String)STRING_BODY, ResponseDefinition.class);
        MatcherAssert.assertThat((Object)responseDef.getBase64Body(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)responseDef.getJsonBody(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)responseDef.getBody(), (Matcher)Matchers.is((Object)"String content"));
    }

    @Test
    public void correctlyUnmarshalsFromJsonWhenBodyIsJson() {
        ResponseDefinition responseDef = (ResponseDefinition)Json.read((String)JSON_BODY, ResponseDefinition.class);
        MatcherAssert.assertThat((Object)responseDef.getBase64Body(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)responseDef.getBody(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        JsonNode jsonNode = Json.node((String)"{\"name\":\"wirmock\",\"isCool\":true}");
        MatcherAssert.assertThat((Object)responseDef.getJsonBody(), (Matcher)Matchers.is((Object)jsonNode));
    }

    @Test
    public void correctlyMarshalsToJsonWhenBodyIsAString() throws Exception {
        ResponseDefinition responseDef = ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody("String content").build();
        JSONAssert.assertEquals((String)STRING_BODY, (String)Json.write((Object)responseDef), (boolean)false);
    }

    @Test
    public void correctlyUnmarshalsFromJsonWhenBodyIsBinary() {
        ResponseDefinition responseDef = (ResponseDefinition)Json.read((String)BINARY_BODY, ResponseDefinition.class);
        MatcherAssert.assertThat((Object)responseDef.getBody(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)responseDef.getByteBody(), (Matcher)Matchers.is((Object)BODY));
    }

    @Test
    public void correctlyMarshalsToJsonWhenBodyIsBinary() throws Exception {
        ResponseDefinition responseDef = ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBase64Body(BASE64_BODY).build();
        String actualJson = Json.write((Object)responseDef);
        JSONAssert.assertEquals((String)actualJson, (String)BINARY_BODY, (boolean)false);
    }

    @Test
    public void indicatesBodyFileIfBodyContentIsNotAlsoSpecified() {
        ResponseDefinition responseDefinition = ResponseDefinitionBuilder.responseDefinition().withBodyFile("my-file").build();
        Assertions.assertTrue((boolean)responseDefinition.specifiesBodyFile());
        Assertions.assertFalse((boolean)responseDefinition.specifiesBodyContent());
    }

    @Test
    public void doesNotIndicateBodyFileIfBodyContentIsAlsoSpecified() {
        ResponseDefinition responseDefinition = ResponseDefinitionBuilder.responseDefinition().withBodyFile("my-file").withBody("hello").build();
        Assertions.assertFalse((boolean)responseDefinition.specifiesBodyFile());
        Assertions.assertTrue((boolean)responseDefinition.specifiesBodyContent());
    }

    @Test
    public void omitsResponseTransformerAttributesFromJsonWhenEmpty() {
        String json = Json.write((Object)new ResponseDefinition(200, ""));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"transformers")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"transformerParameters")));
    }
}

