/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.MockHttpResponder;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class StubRequestHandlerTest {
    private StubServer stubServer;
    private ResponseRenderer responseRenderer;
    private MockHttpResponder httpResponder;
    private Admin admin;
    private RequestJournal requestJournal;
    private StubRequestHandler requestHandler;

    @BeforeEach
    public void init() {
        this.stubServer = (StubServer)Mockito.mock(StubServer.class);
        this.responseRenderer = (ResponseRenderer)Mockito.mock(ResponseRenderer.class);
        this.httpResponder = new MockHttpResponder();
        this.admin = (Admin)Mockito.mock(Admin.class);
        this.requestJournal = (RequestJournal)Mockito.mock(RequestJournal.class);
        this.requestHandler = new StubRequestHandler(this.stubServer, this.responseRenderer, this.admin, Collections.emptyMap(), this.requestJournal, Collections.emptyList(), false, DataTruncationSettings.NO_TRUNCATION);
    }

    @Test
    public void returnsResponseIndicatedByMappings() {
        Mockito.when((Object)this.stubServer.serveStubFor((Request)ArgumentMatchers.any(Request.class))).thenReturn((Object)ServeEvent.of((LoggedRequest)MockRequest.mockRequest().protocol("HTTP/2").asLoggedRequest(), (ResponseDefinition)new ResponseDefinition(200, "Body content")));
        Response mockResponse = Response.response().status(200).body("Body content").headers(new HttpHeaders(new HttpHeader[]{new HttpHeader("Content-Type", new String[]{"application/json"}), new HttpHeader("Matched-Stub-Id", new String[]{"123"})})).build();
        Mockito.when((Object)this.responseRenderer.render((ServeEvent)ArgumentMatchers.any(ServeEvent.class))).thenReturn((Object)mockResponse);
        Request request = MockRequestBuilder.aRequest().withUrl("/the/required/resource").withMethod(RequestMethod.GET).withProtocol("HTTP/2").build();
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
        Response response = this.httpResponder.response;
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)Matchers.is((Object)"Body content"));
        MatcherAssert.assertThat((Object)response.toString(), (Matcher)Matchers.is((Object)"HTTP/2 200\nContent-Type: [application/json]\nMatched-Stub-Id: [123]\n"));
    }

    @Test
    public void shouldNotifyListenersOnRequest() {
        Request request = MockRequestBuilder.aRequest().build();
        RequestListener listener = (RequestListener)Mockito.mock(RequestListener.class);
        this.requestHandler.addRequestListener(listener);
        ((StubServer)Mockito.doReturn((Object)ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)request), (ResponseDefinition)ResponseDefinition.notConfigured())).when((Object)this.stubServer)).serveStubFor(request);
        Mockito.when((Object)this.responseRenderer.render((ServeEvent)ArgumentMatchers.any(ServeEvent.class))).thenReturn((Object)new Response.Builder().build());
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
        ((RequestListener)Mockito.verify((Object)listener)).requestReceived((Request)ArgumentMatchers.eq((Object)request), (Response)ArgumentMatchers.any(Response.class));
    }

    @Test
    public void shouldLogInfoOnRequest() {
        Request request = MockRequestBuilder.aRequest().withUrl("/").withMethod(RequestMethod.GET).withClientIp("1.2.3.5").build();
        ((StubServer)Mockito.doReturn((Object)ServeEvent.forUnmatchedRequest((LoggedRequest)LoggedRequest.createFrom((Request)request))).when((Object)this.stubServer)).serveStubFor(request);
        Mockito.when((Object)this.responseRenderer.render((ServeEvent)ArgumentMatchers.any(ServeEvent.class))).thenReturn((Object)new Response.Builder().build());
        TestNotifier notifier = TestNotifier.createAndSet();
        this.requestHandler.handle(request, (HttpResponder)this.httpResponder);
        notifier.revert();
        MatcherAssert.assertThat((Object)notifier.getErrorMessages().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)notifier.getInfoMessages().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)notifier.getInfoMessages().get(0), (Matcher)CoreMatchers.containsString((String)"1.2.3.5 - GET /"));
    }
}

