/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;

public class MockRequestBuilder {
    private String url = "/";
    private RequestMethod method = RequestMethod.GET;
    private String clientIp = "x.x.x.x";
    private List<HttpHeader> individualHeaders = Lists.newArrayList();
    private Map<String, Cookie> cookies = Maps.newHashMap();
    private List<QueryParameter> queryParameters = Lists.newArrayList();
    private String body = "";
    private String bodyAsBase64 = "";
    private Collection<Request.Part> multiparts = Lists.newArrayList();
    private String protocol = "HTTP/1.1";
    private boolean browserProxyRequest = false;
    private String mockName;

    public MockRequestBuilder() {
    }

    public MockRequestBuilder(String mockName) {
        this.mockName = mockName;
    }

    public static MockRequestBuilder aRequest() {
        return new MockRequestBuilder();
    }

    public static MockRequestBuilder aRequest(String mockName) {
        return new MockRequestBuilder(mockName);
    }

    public MockRequestBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public MockRequestBuilder withQueryParameter(String key, String ... values) {
        this.queryParameters.add(new QueryParameter(key, Arrays.asList(values)));
        return this;
    }

    public MockRequestBuilder withMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    public MockRequestBuilder withClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public MockRequestBuilder withHeader(String key, String value) {
        this.individualHeaders.add(new HttpHeader(key, new String[]{value}));
        return this;
    }

    public MockRequestBuilder withCookie(String key, String value) {
        this.cookies.put(key, new Cookie(value));
        return this;
    }

    public MockRequestBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public MockRequestBuilder withBodyAsBase64(String bodyAsBase64) {
        this.bodyAsBase64 = bodyAsBase64;
        return this;
    }

    public MockRequestBuilder asBrowserProxyRequest() {
        this.browserProxyRequest = true;
        return this;
    }

    public MockRequestBuilder withMultiparts(Collection<Request.Part> parts) {
        this.multiparts = parts;
        return this;
    }

    public MockRequestBuilder withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Request build() {
        HttpHeaders headers = new HttpHeaders(this.individualHeaders);
        Request request = this.mockName == null ? (Request)Mockito.mock(Request.class) : (Request)Mockito.mock(Request.class, (String)this.mockName);
        Mockito.when((Object)request.getUrl()).thenReturn((Object)this.url);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)this.method);
        Mockito.when((Object)request.getClientIp()).thenReturn((Object)this.clientIp);
        for (HttpHeader header : headers.all()) {
            Mockito.when((Object)request.containsHeader(header.key())).thenReturn((Object)true);
            Mockito.when((Object)request.getHeader(header.key())).thenReturn((Object)header.firstValue());
        }
        for (HttpHeader header : headers.all()) {
            Mockito.when((Object)request.header(header.key())).thenReturn((Object)header);
            if (!header.key().equals("Content-Type") || !header.isPresent()) continue;
            Mockito.when((Object)request.contentTypeHeader()).thenReturn((Object)new ContentTypeHeader(header.firstValue()));
        }
        for (QueryParameter queryParameter : this.queryParameters) {
            Mockito.when((Object)request.queryParameter(queryParameter.key())).thenReturn((Object)queryParameter);
        }
        Mockito.when((Object)request.header((String)Mockito.any(String.class))).thenReturn((Object)HttpHeader.httpHeader((String)"key", (String[])new String[]{"value"}));
        Mockito.when((Object)request.getHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)request.getAllHeaderKeys()).thenReturn((Object)Sets.newLinkedHashSet((Iterable)headers.keys()));
        Mockito.when((Object)request.containsHeader((String)Mockito.any(String.class))).thenReturn((Object)false);
        Mockito.when((Object)request.getCookies()).thenReturn(this.cookies);
        Mockito.when((Object)request.getBody()).thenReturn((Object)this.body.getBytes());
        Mockito.when((Object)request.getBodyAsString()).thenReturn((Object)this.body);
        Mockito.when((Object)request.getBodyAsBase64()).thenReturn((Object)this.bodyAsBase64);
        Mockito.when((Object)request.getAbsoluteUrl()).thenReturn((Object)("http://localhost:8080" + this.url));
        Mockito.when((Object)request.isBrowserProxyRequest()).thenReturn((Object)this.browserProxyRequest);
        Mockito.when((Object)request.isMultipart()).thenReturn((Object)(this.multiparts != null && !this.multiparts.isEmpty() ? 1 : 0));
        Mockito.when((Object)request.getParts()).thenReturn(this.multiparts);
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)this.protocol);
        return request;
    }
}

