/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.lang3.SystemUtils;

public class TestFiles {
    public static final String TRUST_STORE_PASSWORD = "mytruststorepassword";
    public static final String TRUST_STORE_NAME = TestFiles.getTrustStoreRelativeName();
    public static final String TRUST_STORE_PATH = TestFiles.filePath(TRUST_STORE_NAME);
    public static final String KEY_STORE_PATH = TestFiles.filePath("test-keystore");
    public static final String KEY_STORE_WITH_CA_PATH = TestFiles.filePath("test-keystore-with-ca");

    private static String getTrustStoreRelativeName() {
        return System.getProperty("java.specification.version").equals("1.7") ? "test-truststore.jks" : "test-truststore.pkcs12";
    }

    public static String defaultTestFilesRoot() {
        return TestFiles.filePath("test-file-root");
    }

    public static String file(String path) {
        try {
            String text = Resources.toString((URL)Resources.getResource((String)path), (Charset)Charsets.UTF_8);
            if (SystemUtils.IS_OS_WINDOWS) {
                text = text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
            }
            return text;
        }
        catch (IOException e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, String.class);
        }
    }

    public static String filePath(String path) {
        try {
            return new File(Resources.getResource((String)path).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, String.class);
        }
    }

    public static String sampleWarRootDir() {
        return new File("sample-war").exists() ? "sample-war" : "../sample-war";
    }
}

