/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.nio.charset.Charset;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;

public class WireMockResponse {
    private final ClassicHttpResponse httpResponse;
    private final byte[] content;

    public WireMockResponse(ClassicHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        this.content = HttpClientUtils.getEntityAsByteArrayAndCloseStream((ClassicHttpResponse)httpResponse);
    }

    public int statusCode() {
        return this.httpResponse.getCode();
    }

    public String content() {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, Charset.forName(Charsets.UTF_8.name()));
    }

    public byte[] binaryContent() {
        return this.content;
    }

    public String firstHeader(String key) {
        return (String)Iterables.getFirst((Iterable)this.headers().get((Object)key), null);
    }

    public Multimap<String, String> headers() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Header header : this.httpResponse.getHeaders()) {
            builder.put((Object)header.getName(), (Object)header.getValue());
        }
        return builder.build();
    }

    public String statusMessage() {
        return this.httpResponse.getReasonPhrase();
    }
}

