/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.MimeType;
import com.github.tomakehurst.wiremock.testsupport.MultipartBody;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;

public class WireMockTestClient {
    private static final String LOCAL_WIREMOCK_ROOT = "http://%s:%d%s";
    private static final String LOCAL_WIREMOCK_NEW_RESPONSE_URL = "http://%s:%d/__admin/mappings/new";
    private static final String LOCAL_WIREMOCK_EDIT_RESPONSE_URL = "http://%s:%d/__admin/mappings/edit";
    private static final String LOCAL_WIREMOCK_RESET_DEFAULT_MAPPINS_URL = "http://%s:%d/__admin/mappings/reset";
    private static final String LOCAL_WIREMOCK_SNAPSHOT_PATH = "/__admin/recordings/snapshot";
    private int port;
    private String address;

    public WireMockTestClient(int port, String address) {
        this.port = port;
        this.address = address;
    }

    public WireMockTestClient(int port) {
        this(port, "localhost");
    }

    public WireMockTestClient() {
        this(8080);
    }

    private String mockServiceUrlFor(String path) {
        return String.format(LOCAL_WIREMOCK_ROOT, this.address, this.port, path);
    }

    private String newMappingUrl() {
        return String.format(LOCAL_WIREMOCK_NEW_RESPONSE_URL, this.address, this.port);
    }

    private String editMappingUrl() {
        return String.format(LOCAL_WIREMOCK_EDIT_RESPONSE_URL, this.address, this.port);
    }

    private String resetDefaultMappingsUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_DEFAULT_MAPPINS_URL, this.address, this.port);
    }

    public WireMockResponse get(String url, TestHttpHeader ... headers) {
        String actualUrl = URI.create(url).isAbsolute() ? url : this.mockServiceUrlFor(url);
        HttpGet httpRequest = new HttpGet(actualUrl);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    public WireMockResponse getViaProxy(String url) {
        return this.getViaProxy(url, this.port);
    }

    public WireMockResponse getViaProxy(String url, int proxyPort) {
        return this.getViaProxy(url, proxyPort, HttpHost.DEFAULT_SCHEME.getId());
    }

    public WireMockResponse getViaProxy(String url, int proxyPort, String scheme) {
        URI targetUri = URI.create(url);
        HttpHost proxy = new HttpHost(scheme, this.address, proxyPort);
        CloseableHttpClient httpClientUsingProxy = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(WireMockTestClient.buildTrustWireMockDefaultCertificateSSLContext()).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build()).build()).setProxy(proxy).build();
        try {
            HttpHost target = new HttpHost(targetUri.getScheme(), targetUri.getHost(), targetUri.getPort());
            HttpGet req = new HttpGet(targetUri.getPath() + (Strings.isNullOrEmpty((String)targetUri.getQuery()) ? "" : "?" + targetUri.getQuery()));
            req.removeHeaders("Host");
            System.out.println("executing request to " + targetUri + "(" + target + ") via " + proxy);
            ClassicHttpResponse httpResponse = httpClientUsingProxy.execute(target, (ClassicHttpRequest)req);
            return new WireMockResponse(httpResponse);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public WireMockResponse put(String url, TestHttpHeader ... headers) {
        HttpPut httpRequest = new HttpPut(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    public WireMockResponse putWithBody(String url, String body, String contentType, TestHttpHeader ... headers) {
        HttpPut httpPut = new HttpPut(this.mockServiceUrlFor(url));
        return this.requestWithBody((HttpUriRequestBase)httpPut, body, contentType, headers);
    }

    public WireMockResponse patchWithBody(String url, String body, String contentType, TestHttpHeader ... headers) {
        HttpPatch httpPatch = new HttpPatch(this.mockServiceUrlFor(url));
        return this.requestWithBody((HttpUriRequestBase)httpPatch, body, contentType, headers);
    }

    private WireMockResponse requestWithBody(HttpUriRequestBase request, String body, String contentType, TestHttpHeader ... headers) {
        request.setEntity((HttpEntity)new StringEntity(body, ContentType.create((String)contentType, (String)"utf-8")));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)request, headers);
    }

    public WireMockResponse postWithBody(String url, String body, String bodyMimeType, String bodyEncoding) {
        return this.post(url, (HttpEntity)new StringEntity(body, ContentType.create((String)bodyMimeType, (String)bodyEncoding)), new TestHttpHeader[0]);
    }

    public WireMockResponse postWithMultiparts(String url, Collection<MultipartBody> parts, TestHttpHeader ... headers) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (parts != null) {
            for (MultipartBody part : parts) {
                builder.addPart(part.getFilename(), (ContentBody)part);
            }
        }
        return this.post(url, builder.build(), headers);
    }

    public WireMockResponse postWithChunkedBody(String url, byte[] body) {
        return this.post(url, (HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(body), -1L, ContentType.DEFAULT_BINARY), new TestHttpHeader[0]);
    }

    public WireMockResponse post(String url, HttpEntity entity, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity(entity);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse postJson(String url, String body, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse postXml(String url, String body, TestHttpHeader ... headers) {
        HttpPost httpPost = new HttpPost(this.mockServiceUrlFor(url));
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_XML));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPost, headers);
    }

    public WireMockResponse patchWithBody(String url, String body, String bodyMimeType, String bodyEncoding) {
        return this.patch(url, (HttpEntity)new StringEntity(body, ContentType.create((String)bodyMimeType, (String)bodyEncoding)));
    }

    public WireMockResponse patch(String url, HttpEntity entity) {
        HttpPatch httpPatch = new HttpPatch(this.mockServiceUrlFor(url));
        httpPatch.setEntity(entity);
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpPatch, new TestHttpHeader[0]);
    }

    public WireMockResponse delete(String url) {
        HttpDelete httpDelete = new HttpDelete(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpDelete, new TestHttpHeader[0]);
    }

    public WireMockResponse options(String url, TestHttpHeader ... headers) {
        HttpOptions httpOptions = new HttpOptions(this.mockServiceUrlFor(url));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpOptions, headers);
    }

    public void addResponse(String responseSpecJson) {
        this.addResponse(responseSpecJson, "utf-8");
    }

    public void addResponse(String responseSpecJson, String charset) {
        int status = this.postJsonAndReturnStatus(this.newMappingUrl(), responseSpecJson, charset);
        if (status != 201) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public void editMapping(String mappingSpecJson) {
        int status = this.postJsonAndReturnStatus(this.editMappingUrl(), mappingSpecJson);
        if (status != 204) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public void resetDefaultMappings() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetDefaultMappingsUrl());
        if (status != 200) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    public String snapshot(String snapshotSpecJson) {
        WireMockResponse response = this.postJson(LOCAL_WIREMOCK_SNAPSHOT_PATH, snapshotSpecJson, new TestHttpHeader[0]);
        if (response.statusCode() != 200) {
            throw new RuntimeException("Returned status code was " + response.statusCode());
        }
        return response.content();
    }

    private int postJsonAndReturnStatus(String url, String json) {
        return this.postJsonAndReturnStatus(url, json, "utf-8");
    }

    private int postJsonAndReturnStatus(String url, String json, String charset) {
        HttpPost post = new HttpPost(url);
        try {
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, ContentType.create((String)MimeType.JSON.toString(), (String)charset)));
            }
            CloseableHttpResponse httpResponse = WireMockTestClient.httpClient().execute((ClassicHttpRequest)post);
            return httpResponse.getCode();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int postEmptyBodyAndReturnStatus(String url) {
        return this.postJsonAndReturnStatus(url, null);
    }

    private WireMockResponse executeMethodAndConvertExceptions(HttpUriRequest httpRequest, TestHttpHeader ... headers) {
        try {
            for (TestHttpHeader header : headers) {
                httpRequest.addHeader(header.getName(), (Object)header.getValue());
            }
            CloseableHttpResponse httpResponse = WireMockTestClient.httpClient().execute((ClassicHttpRequest)httpRequest);
            return new WireMockResponse((ClassicHttpResponse)httpResponse);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public WireMockResponse getWithPreemptiveCredentials(String url, int port, String username, String password) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicScheme basicAuth = new BasicScheme();
        basicAuth.initPreemptive((Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
        HttpClientContext localContext = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", port);
        localContext.resetAuthExchange(target, (AuthScheme)basicAuth);
        try {
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(target, (ClassicHttpRequest)httpget, (HttpContext)localContext);
            return new WireMockResponse((ClassicHttpResponse)response);
        }
        catch (IOException e) {
            return (WireMockResponse)Exceptions.throwUnchecked((Throwable)e, WireMockResponse.class);
        }
    }

    public WireMockResponse request(String methodName, String url, TestHttpHeader ... headers) {
        HttpUriRequestBase httpRequest = new HttpUriRequestBase(methodName, URI.create(this.mockServiceUrlFor(url)));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    public WireMockResponse request(String methodName, String url, String body, TestHttpHeader ... headers) {
        HttpUriRequestBase httpRequest = new HttpUriRequestBase(methodName, URI.create(this.mockServiceUrlFor(url)));
        httpRequest.setEntity((HttpEntity)new StringEntity(body));
        return this.executeMethodAndConvertExceptions((HttpUriRequest)httpRequest, headers);
    }

    private static CloseableHttpClient httpClient() {
        return HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setConnectionFactory((HttpConnectionFactory)new ManagedHttpClientConnectionFactory(null, CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build(), null)).build()).build();
    }

    private static SSLContext buildTrustWireMockDefaultCertificateSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) {
                    return chain[0].getSubjectDN().getName().startsWith("CN=Tom Akehurst") || chain[0].getSubjectDN().getName().equals("CN=WireMock Local Self Signed Root Certificate") || chain.length == 2 && chain[1].getSubjectDN().getName().equals("CN=WireMock Local Self Signed Root Certificate");
                }
            }).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked((Throwable)e, SSLContext.class);
        }
    }
}

