/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DiffTest {
    @Test
    public void correctlyRendersJUnitStyleDiffMessage() {
        String diff = JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"expected", (Object)"actual");
        MatcherAssert.assertThat((Object)diff, (Matcher)Matchers.is((Object)" expected:<\nexpected> but was:<\nactual>"));
    }

    @Test
    public void showsDiffForNonMatchingRequestMethod() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/thing\n", (Object)"POST\n/thing\n")));
    }

    @Test
    public void showsDiffForUrlEqualTo() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/expected")).build(), (Request)MockRequest.mockRequest().url("/actual"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/expected\n", (Object)"ANY\n/actual\n")));
    }

    @Test
    public void showsDiffForUrlPathMatching() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlPathMatching((String)"/expected/.*")).build(), (Request)MockRequest.mockRequest().url("/actual"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n[path regex] /expected/.*\n", (Object)"ANY\n/actual\n")));
    }

    @Test
    public void showsDiffsForSingleNonMatchingHeaderAndMatchingHeader() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("X-My-Header", WireMock.equalTo((String)"expected")).build(), (Request)MockRequest.mockRequest().url("/thing").header("Content-Type", "application/json").header("X-My-Header", "actual"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\nContent-Type: application/json\nX-My-Header: expected\n", (Object)"ANY\n/thing\n\nContent-Type: application/json\nX-My-Header: actual\n")));
    }

    @Test
    public void showsDiffWhenRequestHeaderIsAbsent() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withHeader("X-My-Header", WireMock.equalTo((String)"expected")).build(), (Request)MockRequest.mockRequest().url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\nX-My-Header: expected\n", (Object)"ANY\n/thing\n\n\n")));
    }

    @Test
    public void showsHeaders() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withHeader("X-My-Header", WireMock.equalTo((String)"expected")).build(), (Request)MockRequest.mockRequest().url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\nX-My-Header: expected\n", (Object)"ANY\n/thing\n\n\n")));
    }

    @Test
    public void showsRequestBody() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\n    \"outer\": {\n        \"inner\": {\n            \"thing\": 1\n        }\n    }\n}")).build(), (Request)MockRequest.mockRequest().url("/thing").body("{\n    \"outer\": {}\n}"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)("ANY\n/thing\n\n{" + System.lineSeparator() + "  \"outer\" : {" + System.lineSeparator() + "    \"inner\" : {" + System.lineSeparator() + "      \"thing\" : 1" + System.lineSeparator() + "    }" + System.lineSeparator() + "  }" + System.lineSeparator() + "}"), (Object)("ANY\n/thing\n\n{" + System.lineSeparator() + "  \"outer\" : { }" + System.lineSeparator() + "}"))));
    }

    @Test
    public void prettyPrintsJsonRequestBody() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"outer\": {\"inner:\": {\"thing\": 1}}}")).build(), (Request)MockRequest.mockRequest().url("/thing").body("{\"outer\": {}}"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)("ANY\n/thing\n\n{" + System.lineSeparator() + "  \"outer\" : {" + System.lineSeparator() + "    \"inner:\" : {" + System.lineSeparator() + "      \"thing\" : 1" + System.lineSeparator() + "    }" + System.lineSeparator() + "  }" + System.lineSeparator() + "}"), (Object)("ANY\n/thing\n\n{" + System.lineSeparator() + "  \"outer\" : { }" + System.lineSeparator() + "}"))));
    }

    @Test
    public void showsJsonPathExpectations() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"@.notfound")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"@.nothereeither")).build(), (Request)MockRequest.mockRequest().url("/thing").body("{\n    \"outer\": {\n        \"inner:\": {\n            \"thing\": 1\n        }\n    }\n}"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\n@.notfound\n@.nothereeither", (Object)"ANY\n/thing\n\n{\n    \"outer\": {\n        \"inner:\": {\n            \"thing\": 1\n        }\n    }\n}\n{\n    \"outer\": {\n        \"inner:\": {\n            \"thing\": 1\n        }\n    }\n}")));
    }

    @Test
    public void prettyPrintsXml() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<my-elements><one attr-one=\"1111\" /><two /><three /></my-elements>")).build(), (Request)MockRequest.mockRequest().url("/thing").body("<my-elements><one attr-one=\"2222\" /><two /><three /></my-elements>"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)("ANY\n/thing\n\n<my-elements>" + System.lineSeparator() + "  <one attr-one=\"1111\"/>" + System.lineSeparator() + "  <two/>" + System.lineSeparator() + "  <three/>" + System.lineSeparator() + "</my-elements>" + System.lineSeparator()), (Object)("ANY\n/thing\n\n<my-elements>" + System.lineSeparator() + "  <one attr-one=\"2222\"/>" + System.lineSeparator() + "  <two/>" + System.lineSeparator() + "  <three/>" + System.lineSeparator() + "</my-elements>" + System.lineSeparator()))));
    }

    @Test
    public void showsCookiesInDiffWhenNotMatching() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withCookie("my_cookie", WireMock.equalTo((String)"expected-cookie")).build(), (Request)MockRequest.mockRequest().url("/thing").cookie("my_cookie", "actual-cookie"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\nCookie: my_cookie=expected-cookie\n", (Object)"ANY\n/thing\n\nactual-cookie\n")));
    }

    @Test
    public void showsQueryParametersInDiffWhenNotMatching() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlPathEqualTo((String)"/thing")).withQueryParam("search", WireMock.equalTo((String)"everything")).build(), (Request)MockRequest.mockRequest().url("/thing?search=nothing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing?search=nothing\n\nQuery: search = everything\n", (Object)"ANY\n/thing?search=nothing\n\nsearch: nothing\n")));
    }

    @Test
    public void showsCookiesInDiffAbsentFromRequest() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withCookie("my_cookie", WireMock.equalTo((String)"expected-cookie")).build(), (Request)MockRequest.mockRequest().url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"ANY\n/thing\n\nCookie: my_cookie=expected-cookie\n", (Object)"ANY\n/thing\n\n\n")));
    }

    @Test
    public void indicatesThatAnInlineCustomMatcherDidNotMatch() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).andMatching((ValueMatcher)new ValueMatcher<Request>(){

            public MatchResult match(Request value) {
                return MatchResult.noMatch();
            }
        }).build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/thing\n\n[custom matcher]", (Object)"GET\n/thing\n\n ")));
    }

    @Test
    public void indicatesThatANamedCustomMatcherDidNotMatch() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).andMatching("my-custom-matcher").build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/thing\n\n[custom matcher: my-custom-matcher]", (Object)"GET\n/thing\n\n[custom matcher: my-custom-matcher]")));
    }

    @Test
    public void handlesAbsentRequestBody() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withRequestBody((ContentPattern)WireMock.absent()).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).body("not absent").url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"POST\n/thing\n\n(absent)", (Object)"POST\n/thing\n\nnot absent")));
    }

    @Test
    public void indicatesThatScenarioStateDiffersWhenStubAndRequestOtherwiseMatch() {
        Diff diff = new Diff(WireMock.get((String)"/stateful").inScenario("my-steps").whenScenarioStateIs("step2").willReturn(WireMock.ok((String)"Yep")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/stateful"), "Started");
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/stateful\n\n[Scenario 'my-steps' state: step2]", (Object)"GET\n/stateful\n\n[Scenario 'my-steps' state: Started]")));
    }

    @Test
    public void includesSpecificDiffForJsonPathSubMatchWhenElementFound() {
        Diff diff = new Diff(WireMock.post((String)"/submatch").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.name", (StringValuePattern)WireMock.containing((String)"Tom"))).willReturn(WireMock.ok((String)"Yep")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/submatch").body("{\"name\": \"Rob\"}"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"POST\n/submatch\n\n$.name [contains] Tom", (Object)"POST\n/submatch\n\nRob")));
    }

    @Test
    public void includesSpecificDiffForJsonPathSubMatchWhenElementNotFound() {
        Diff diff = new Diff(WireMock.post((String)"/submatch").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.name", (StringValuePattern)WireMock.containing((String)"Tom"))).willReturn(WireMock.ok((String)"Yep")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/submatch").body("{\"id\": \"abc123\"}"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"POST\n/submatch\n\n$.name [contains] Tom", (Object)"POST\n/submatch\n\n{\"id\": \"abc123\"}")));
    }

    @Test
    public void includeHostnameIfSpecifiedWithEqualTo() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withHost(WireMock.equalTo((String)"my.host")).build(), (Request)MockRequest.mockRequest().host("wrong.host").url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"my.host\nANY\n/thing\n", (Object)"wrong.host\nANY\n/thing\n")));
    }

    @Test
    public void includeHostnameIfSpecifiedWithNonEqualTo() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withHost(WireMock.containing((String)"my.host")).build(), (Request)MockRequest.mockRequest().host("wrong.host").url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"[contains] my.host\nANY\n/thing\n", (Object)"wrong.host\nANY\n/thing\n")));
    }

    @Test
    public void includePortIfSpecified() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withPort(5544).build(), (Request)MockRequest.mockRequest().port(6543).url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"5544\nANY\n/thing\n", (Object)"6543\nANY\n/thing\n")));
    }

    @Test
    public void includeSchemeIfSpecified() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.ANY, (UrlPattern)WireMock.urlEqualTo((String)"/thing")).withScheme("https").build(), (Request)MockRequest.mockRequest().scheme("http").url("/thing"));
        MatcherAssert.assertThat((Object)diff.toString(), (Matcher)Matchers.is((Object)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"https\nANY\n/thing\n", (Object)"http\nANY\n/thing\n")));
    }
}

