/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MockMultipart;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.PlainTextDiffRenderer;
import java.util.Collections;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.condition.OS;

public class PlainTextDiffRendererTest {
    PlainTextDiffRenderer diffRenderer;

    @BeforeEach
    public void init() {
        this.diffRenderer = new PlainTextDiffRenderer(Collections.singletonMap("my-custom-matcher", new MyCustomMatcher()));
    }

    @Test
    public void rendersWithDifferingUrlHeaderAndJsonBody() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("X-My-Header", WireMock.containing((String)"correct value")).withHeader("Accept", WireMock.matching((String)"text/plain.*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{     \n    \"thing\": {               \n        \"stuff\": [1, 2, 3]   \n    }                          \n}")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thin").header("X-My-Header", "wrong value").header("Accept", "text/plain").body("{                        \n    \"thing\": {           \n        \"nothing\": {}    \n    }                      \n}"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_ascii.txt")));
    }

    @Test
    public void rendersWithDifferingCookies() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Cookie diff").withCookie("Cookie_1", WireMock.containing((String)"one value")).withCookie("Second_Cookie", WireMock.matching((String)"cookie two value [0-9]*")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").cookie("Cookie_1", "zero value").cookie("Second_Cookie", "cookie two value 123"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_cookies.txt")));
    }

    @Test
    public void rendersWithDifferingQueryParameters() {
        Diff diff = new Diff(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/thing")).withName("Query params diff").withQueryParam("one", WireMock.equalTo((String)"1")).withQueryParam("two", WireMock.containing((String)"two things")).withQueryParam("three", WireMock.matching((String)"[a-z]{5}")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/thing?one=2&two=wrong%20things&three=abcde"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_query.txt")));
    }

    @Test
    public void wrapsLargeJsonBodiesAppropriately() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("Accept", WireMock.equalTo((String)"text/plain")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\n  \"one\": {\n    \"two\": {\n      \"three\": {\n        \"four\": {\n          \"five\": {\n            \"six\": \"superduperlongvaluethatshouldwrapokregardless_superduperlongvaluethatshouldwrapokregardless_superduperlongvaluethatshouldwrapokregardless_superduperlongvaluethatshouldwrapokregardless\"\n          }\n        }\n      }\n    }\n  }\n}")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").header("Accept", "text/plain").body(Json.prettyPrint((String)"{\n  \"one\": {\n    \"two\": {\n      \"three\": {\n        \"four\": {\n          \"five\": {\n            \"six\": \"totally_the_wrong_value\"\n          }\n        }\n      }\n    }\n  }\n}")));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        String expected = SystemUtils.IS_OS_WINDOWS ? TestFiles.file("not-found-diff-sample_large_json_windows.txt") : TestFiles.file("not-found-diff-sample_large_json.txt");
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(expected));
    }

    @Test
    @DisabledForJreRange(min=JRE.JAVA_11, disabledReason="Wrap differs per JRE")
    public void wrapsLargeXmlBodiesAppropriatelyJre8() {
        String output = this.wrapsLargeXmlBodiesAppropriately();
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_large_xml_jre8.txt")));
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_11, disabledReason="Wrap differs per JRE")
    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="Wrap differs per OS")
    public void wrapsLargeXmlBodiesAppropriatelyJre11() {
        String output = this.wrapsLargeXmlBodiesAppropriately();
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_large_xml_jre11.txt")));
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_11, disabledReason="Wrap differs per JRE")
    @EnabledOnOs(value={OS.WINDOWS}, disabledReason="Wrap differs per OS")
    public void wrapsLargeXmlBodiesAppropriatelyJre11Windows() {
        String output = this.wrapsLargeXmlBodiesAppropriately();
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_large_xml_jre11_windows.txt")));
    }

    private String wrapsLargeXmlBodiesAppropriately() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withRequestBody((ContentPattern)WireMock.equalToXml((String)"<deep-things>\n  <thing id=\"1\">\n    <thing id=\"2\">\n      <thing id=\"3\">\n        <thing id=\"4\">\n          <thing id=\"5\">\n            <thing id=\"6\">\n              Super wrong bit of text that should push it way over the length limit!\n            </thing>\n          </thing>\n        </thing>\n      </thing>\n    </thing>\n  </thing>\n</deep-things>")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").body("<deep-things>\n  <thing id=\"1\">\n    <thing id=\"2\">\n      <thing id=\"3\">\n        <thing id=\"4\">\n          <thing id=\"5\">\n            <thing id=\"6\">\n              Super long bit of text that should push it way over the length limit!\n            </thing>\n          </thing>\n        </thing>\n      </thing>\n    </thing>\n  </thing>\n</deep-things>"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        return output;
    }

    @Test
    public void showsMissingHeaderMessage() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Missing header stub").withHeader("X-My-Header", WireMock.equalTo((String)"correct value")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_missing_header.txt")));
    }

    @Test
    public void showsJsonPathMismatch() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..six")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..seven")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").body(Json.prettyPrint((String)"{\n  \"one\": {\n    \"two\": {\n      \"three\": {\n        \"four\": {\n          \"five\": {\n            \"six\": \"match this\"\n          }\n        }\n      }\n    }\n  }\n}")));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        String expected = TestFiles.file("not-found-diff-sample_json-path.txt");
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(expected));
    }

    @Test
    public void showsXPathWithSubMatchMismatch() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//thing/text()", (StringValuePattern)WireMock.equalTo((String)"two"))).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").body("<stuff>\n    <thing>one</thing>\n</stuff>"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        String expected = TestFiles.file("not-found-diff-sample_xpath-with-submatch.txt");
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(expected));
    }

    @Test
    public void showsUrlRegexUnescapedMessage() {
        Diff diff = new Diff(WireMock.get((UrlPattern)WireMock.urlMatching((String)"thing?query=value")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/thing"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_url-pattern.txt")));
    }

    @Test
    public void showsMultipartDifference() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Multipart request body stub").withMultipartRequestBody(WireMock.aMultipart().withName("part_one").withHeader("X-My-Stuff", WireMock.containing((String)"stuff_parts")).withBody((ContentPattern)WireMock.matching((String)"Some expected text.*"))).withMultipartRequestBody(WireMock.aMultipart().withHeader("X-More", WireMock.containing((String)"stuff_parts")).withBody((ContentPattern)WireMock.equalTo((String)"Correct body"))).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").header("Content-Type", "multipart/form-data").part(MockMultipart.mockPart().name("part_one").header("X-My-Stuff", "wrong value").body("Wrong body")).part(MockMultipart.mockPart().name("part_two").body("Correct body")));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_multipart.txt")));
    }

    @Test
    public void showsErrorInDiffWhenMultipartExpectedButNotSent() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Multipart request body stub").withMultipartRequestBody(WireMock.aMultipart().withHeader("X-My-Stuff", WireMock.containing((String)"stuff_parts")).withBody((ContentPattern)WireMock.matching((String)"Some expected text.*"))).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing").body("Non-multipart body"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_no-multipart.txt")));
    }

    @Test
    public void showsErrorInDiffWhenInlineCustomMatcherNotSatisfiedInMixedStub() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Standard and custom matched stub").andMatching((ValueMatcher)new ValueMatcher<Request>(){

            public MatchResult match(Request value) {
                return MatchResult.noMatch();
            }
        }).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_mixed-matchers.txt")));
    }

    @Test
    public void showsErrorInDiffWhenNamedCustomMatcherNotSatisfiedInMixedStub() {
        Diff diff = new Diff(WireMock.post((String)"/thing").withName("Standard and custom matched stub").andMatching("my-custom-matcher", Parameters.one((String)"myVal", (Object)"present")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_mixed-matchers-named-custom.txt")));
    }

    @Test
    public void showsAppropriateErrorInDiffWhenCustomMatcherIsUsedExclusively() {
        Diff diff = new Diff(WireMock.requestMatching((ValueMatcher)new ValueMatcher<Request>(){

            public MatchResult match(Request value) {
                return MatchResult.noMatch();
            }
        }).build(), (Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/thing"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
        MatcherAssert.assertThat((Object)output, WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_only-custom_matcher.txt")));
    }

    @Test
    public void handlesUrlsWithQueryStringAndNoPath() {
        Diff diff = new Diff(RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlMatching((String)"/?q=correct")).build(), (Request)MockRequest.mockRequest().method(RequestMethod.GET).url("/q=wrong"));
        String output = this.diffRenderer.render(diff);
        System.out.println(output);
    }

    public static class MyCustomMatcher
    extends RequestMatcherExtension {
        public MatchResult match(Request request, Parameters parameters) {
            parameters.getString("myVal");
            return MatchResult.noMatch();
        }

        public String getName() {
            return "my-custom-matcher";
        }
    }
}

