/*
 * Decompiled with CFR 0.152.
 */
package ignored;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NearMissExampleTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory("src/main/resources/empty")).failOnUnmatchedRequests(true).build();
    WireMockTestClient client;

    @BeforeEach
    public void init() {
        this.client = new WireMockTestClient(this.wm.getPort());
    }

    @Test
    public void showFullUnmatchedVerification() throws Exception {
        this.client.get("/some-other-thing", new TestHttpHeader[0]);
        this.client.get("/totally-something-else", new TestHttpHeader[0]);
        this.client.get("/whatever", new TestHttpHeader[0]);
        this.client.post("/my-near-miss", (HttpEntity)new StringEntity("{\"data\": { \"one\": 1}}", ContentType.APPLICATION_JSON), TestHttpHeader.withHeader("Content-Type", "application/json"), TestHttpHeader.withHeader("X-Expected", "yes"), TestHttpHeader.withHeader("X-Matched-1", "yes"), TestHttpHeader.withHeader("Cookie", "this=that"), TestHttpHeader.withHeader("Authorization", new BasicCredentials("user", "wrong-pass").asAuthorizationHeaderValue()));
        this.wm.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/a-near-miss")).withHeader("Content-Type", WireMock.equalTo((String)"text/json")).withHeader("X-Expected", WireMock.equalTo((String)"yes")).withHeader("X-Matched-1", WireMock.matching((String)"ye.*")).withHeader("X-Matched-2", WireMock.containing((String)"no")).withCookie("this", WireMock.equalTo((String)"other")).withBasicAuth(new BasicCredentials("user", "pass")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"data\": { \"two\": 1}}")));
    }

    @Test
    public void showSingleUnmatchedRequest() {
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.client.get("/near-misssss", new TestHttpHeader[0]);
    }

    @Test
    public void showManyUnmatchedRequests() {
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.client.get("/near-misssss", new TestHttpHeader[0]);
        this.client.get("/hat", new TestHttpHeader[0]);
        this.client.get("/whatevs", new TestHttpHeader[0]);
    }
}

