/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProhibitedNetworkAddressException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.stream.Stream;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;

public class NetworkAddressRulesAdheringDnsResolver
implements DnsResolver {
    private final DnsResolver delegate;
    private final NetworkAddressRules networkAddressRules;

    public NetworkAddressRulesAdheringDnsResolver(NetworkAddressRules networkAddressRules) {
        this((DnsResolver)SystemDefaultDnsResolver.INSTANCE, networkAddressRules);
    }

    public NetworkAddressRulesAdheringDnsResolver(DnsResolver delegate, NetworkAddressRules networkAddressRules) {
        this.delegate = delegate;
        this.networkAddressRules = networkAddressRules;
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (!this.networkAddressRules.isAllowed(host)) {
            throw new ProhibitedNetworkAddressException();
        }
        InetAddress[] resolved = this.delegate.resolve(host);
        if (Stream.of(resolved).anyMatch(address -> !this.networkAddressRules.isAllowed(address.getHostAddress()))) {
            throw new ProhibitedNetworkAddressException();
        }
        return resolved;
    }

    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        return this.delegate.resolveCanonicalHostname(host);
    }
}

