/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import java.util.HashMap;
import java.util.Map;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.ImmutableMap;

public class Parameters
extends HashMap<String, Object> {
    public Integer getInt(String key) {
        return this.checkValidityAndCast(key, Integer.class);
    }

    public Boolean getBoolean(String key) {
        return this.checkValidityAndCast(key, Boolean.class);
    }

    public String getString(String key) {
        return this.checkValidityAndCast(key, String.class);
    }

    private <T> T checkValidityAndCast(String key, Class<T> type) {
        Preconditions.checkArgument(this.containsKey(key), "Parameter '" + key + "' not present");
        Preconditions.checkArgument(type.isAssignableFrom(this.get(key).getClass()), "Parameter " + key + " is not of type " + type.getSimpleName());
        return (T)this.get(key);
    }

    public static Parameters empty() {
        return new Parameters();
    }

    public static Parameters from(Map<String, Object> parameterMap) {
        Parameters parameters = new Parameters();
        parameters.putAll(parameterMap);
        return parameters;
    }

    public static Parameters one(String name, Object value) {
        return Parameters.from(ImmutableMap.of(name, value));
    }
}

