/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WiremockHelpers;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.helper.AssignHelper;
import wiremock.com.github.jknack.handlebars.helper.NumberHelper;
import wiremock.com.github.jknack.handlebars.helper.StringHelpers;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;

public class ResponseTemplateTransformer
extends ResponseDefinitionTransformer {
    public static final String NAME = "response-template";
    private final boolean global;
    private final Handlebars handlebars;

    public ResponseTemplateTransformer(boolean global) {
        this(global, Collections.emptyMap());
    }

    public ResponseTemplateTransformer(boolean global, String helperName, Helper helper) {
        this(global, ImmutableMap.of(helperName, helper));
    }

    public ResponseTemplateTransformer(boolean global, Map<String, Helper> helpers) {
        this(global, new Handlebars(), helpers);
    }

    public ResponseTemplateTransformer(boolean global, Handlebars handlebars, Map<String, Helper> helpers) {
        this.global = global;
        this.handlebars = handlebars;
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (Enum enum_ : NumberHelper.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (Enum enum_ : WiremockHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        for (Map.Entry<String, Helper> entry : helpers.entrySet()) {
            this.handlebars.registerHelper(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
        final ImmutableMap<String, Object> model = ImmutableMap.builder().put("parameters", MoreObjects.firstNonNull(parameters, Collections.emptyMap())).put("request", (Map<String, RequestTemplateModel>)((Object)RequestTemplateModel.from(request))).build();
        if (responseDefinition.specifiesTextBodyContent()) {
            Template bodyTemplate = this.uncheckedCompileTemplate(responseDefinition.getBody());
            this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate);
        } else if (responseDefinition.specifiesBodyFile()) {
            TextFile file = files.getTextFileNamed(responseDefinition.getBodyFileName());
            Template bodyTemplate = this.uncheckedCompileTemplate(file.readContentsAsString());
            this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate);
        }
        if (responseDefinition.getHeaders() != null) {
            Iterable<HttpHeader> newResponseHeaders = Iterables.transform(responseDefinition.getHeaders().all(), new Function<HttpHeader, HttpHeader>(){

                @Override
                public HttpHeader apply(HttpHeader input) {
                    List<String> newValues = Lists.transform(input.values(), new Function<String, String>(){

                        @Override
                        public String apply(String input) {
                            Template template = ResponseTemplateTransformer.this.uncheckedCompileTemplate(input);
                            return ResponseTemplateTransformer.this.uncheckedApplyTemplate(template, model);
                        }
                    });
                    return new HttpHeader(input.key(), (Collection<String>)newValues);
                }
            });
            newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
        }
        if (responseDefinition.getProxyBaseUrl() != null) {
            Template proxyBaseUrlTemplate = this.uncheckedCompileTemplate(responseDefinition.getProxyBaseUrl());
            String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
            newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
        }
        return newResponseDefBuilder.build();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, ImmutableMap<String, Object> model, Template bodyTemplate) {
        String newBody = this.uncheckedApplyTemplate(bodyTemplate, model);
        newResponseDefBuilder.withBody(newBody);
    }

    private String uncheckedApplyTemplate(Template template, Object context) {
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private Template uncheckedCompileTemplate(String content) {
        try {
            return this.handlebars.compileInline(content);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Template.class);
        }
    }
}

