/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.server.HttpChannel;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;

public class JettyUtils {
    private static final Map<Class<?>, Method> URI_METHOD_BY_CLASS_CACHE = new HashMap();
    private static final boolean IS_JETTY = JettyUtils.isClassExist("wiremock.org.eclipse.jetty.server.Request");

    private JettyUtils() {
    }

    public static boolean isJetty() {
        return IS_JETTY;
    }

    private static boolean isClassExist(String type) {
        try {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = contextCL == null ? JettyUtils.class.getClassLoader() : contextCL;
            Class.forName(type, false, loader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        return (Response)httpServletResponse;
    }

    public static Socket getTlsSocket(Response response) {
        HttpChannel<?> httpChannel = response.getHttpOutput().getHttpChannel();
        SslConnection.DecryptedEndPoint sslEndpoint = (SslConnection.DecryptedEndPoint)httpChannel.getEndPoint();
        EndPoint endpoint = sslEndpoint.getSslConnection().getEndPoint();
        try {
            return (Socket)endpoint.getClass().getMethod("getSocket", new Class[0]).invoke((Object)endpoint, new Object[0]);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Socket.class);
        }
    }

    public static URI getUri(Request request) {
        try {
            return JettyUtils.toUri(JettyUtils.getURIMethodFromClass(request.getClass()).invoke((Object)request, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(request + " does not have a getUri or getHttpURI method");
        }
    }

    private static Method getURIMethodFromClass(Class<?> requestClass) throws NoSuchMethodException {
        Method method;
        if (URI_METHOD_BY_CLASS_CACHE.containsKey(requestClass)) {
            return URI_METHOD_BY_CLASS_CACHE.get(requestClass);
        }
        try {
            method = requestClass.getDeclaredMethod("getUri", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            method = requestClass.getDeclaredMethod("getHttpURI", new Class[0]);
        }
        URI_METHOD_BY_CLASS_CACHE.put(requestClass, method);
        return method;
    }

    private static URI toUri(Object httpURI) {
        return URI.create(httpURI.toString());
    }
}

