/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import wiremock.org.apache.http.HttpConnection;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpHost;
import wiremock.org.apache.http.HttpInetConnection;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestInterceptor;
import wiremock.org.apache.http.HttpVersion;
import wiremock.org.apache.http.ProtocolException;
import wiremock.org.apache.http.ProtocolVersion;
import wiremock.org.apache.http.annotation.Contract;
import wiremock.org.apache.http.annotation.ThreadingBehavior;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.protocol.HttpCoreContext;
import wiremock.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

