/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MemoizingStringValuePattern;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.Strings;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableSet;
import wiremock.com.google.common.collect.Sets;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.builder.DiffBuilder;
import wiremock.org.xmlunit.builder.Input;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonControllers;
import wiremock.org.xmlunit.diff.ComparisonListener;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.DefaultNodeMatcher;
import wiremock.org.xmlunit.diff.Diff;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;
import wiremock.org.xmlunit.diff.DifferenceEvaluators;
import wiremock.org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class EqualToXmlPattern
extends MemoizingStringValuePattern {
    private static Set<ComparisonType> COUNTED_COMPARISONS = ImmutableSet.of(ComparisonType.ELEMENT_TAG_NAME, ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, new ComparisonType[]{ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_LOOKUP, ComparisonType.ATTR_NAME_LOOKUP});
    private final Boolean enablePlaceholders;
    private final String placeholderOpeningDelimiterRegex;
    private final String placeholderClosingDelimiterRegex;
    private final DifferenceEvaluator diffEvaluator;
    private final Set<ComparisonType> exemptedComparisons;
    private final Document expectedXmlDoc;

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        this(expectedValue, null, null, null, null);
    }

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue, @JsonProperty(value="enablePlaceholders") Boolean enablePlaceholders, @JsonProperty(value="placeholderOpeningDelimiterRegex") String placeholderOpeningDelimiterRegex, @JsonProperty(value="placeholderClosingDelimiterRegex") String placeholderClosingDelimiterRegex, @JsonProperty(value="exemptedComparisons") Set<ComparisonType> exemptedComparisons) {
        super(expectedValue);
        this.expectedXmlDoc = Xml.read(expectedValue);
        this.enablePlaceholders = enablePlaceholders;
        this.placeholderOpeningDelimiterRegex = placeholderOpeningDelimiterRegex;
        this.placeholderClosingDelimiterRegex = placeholderClosingDelimiterRegex;
        this.exemptedComparisons = exemptedComparisons;
        IgnoreUncountedDifferenceEvaluator baseDifferenceEvaluator = new IgnoreUncountedDifferenceEvaluator(exemptedComparisons);
        this.diffEvaluator = enablePlaceholders != null && enablePlaceholders != false ? DifferenceEvaluators.chain(baseDifferenceEvaluator, new PlaceholderDifferenceEvaluator(placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex)) : baseDifferenceEvaluator;
    }

    public String getEqualToXml() {
        return (String)this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint((String)this.getValue());
    }

    public Boolean isEnablePlaceholders() {
        return this.enablePlaceholders;
    }

    public String getPlaceholderOpeningDelimiterRegex() {
        return this.placeholderOpeningDelimiterRegex;
    }

    public String getPlaceholderClosingDelimiterRegex() {
        return this.placeholderClosingDelimiterRegex;
    }

    public Set<ComparisonType> getExemptedComparisons() {
        return this.exemptedComparisons;
    }

    @Override
    protected MatchResult calculateMatch(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                try {
                    Diff diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedXmlDoc)).withTest(value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withNodeMatcher(new OrderInvariantNodeMatcher()).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                Diff diff;
                if (Strings.isNullOrEmpty(value)) {
                    return 1.0;
                }
                final AtomicInteger totalComparisons = new AtomicInteger(0);
                final AtomicInteger differences = new AtomicInteger(0);
                try {
                    diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withComparisonListeners(new ComparisonListener(){

                        @Override
                        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                                totalComparisons.incrementAndGet();
                                if (outcome == ComparisonResult.DIFFERENT) {
                                    differences.incrementAndGet();
                                }
                            }
                        }
                    }).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return 1.0;
                }
                LocalNotifier.notifier().info(Joiner.on("\n").join(diff.getDifferences()));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }

    public EqualToXmlPattern exemptingComparisons(ComparisonType ... comparisons) {
        return new EqualToXmlPattern((String)this.expectedValue, this.enablePlaceholders, this.placeholderOpeningDelimiterRegex, this.placeholderClosingDelimiterRegex, ImmutableSet.copyOf(comparisons));
    }

    private static final class OrderInvariantNodeMatcher
    extends DefaultNodeMatcher {
        private static final Comparator<Node> COMPARATOR = new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                return node1.getLocalName().compareTo(node2.getLocalName());
            }
        };

        private OrderInvariantNodeMatcher() {
        }

        @Override
        public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
            return super.match(OrderInvariantNodeMatcher.sort(controlNodes), OrderInvariantNodeMatcher.sort(testNodes));
        }

        private static Iterable<Node> sort(Iterable<Node> nodes) {
            return FluentIterable.from(nodes).toSortedList(COMPARATOR);
        }
    }

    private static class IgnoreUncountedDifferenceEvaluator
    implements DifferenceEvaluator {
        private final Set<ComparisonType> finalCountedComparisons;

        public IgnoreUncountedDifferenceEvaluator(Set<ComparisonType> exemptedComparisons) {
            this.finalCountedComparisons = exemptedComparisons != null ? Sets.difference(COUNTED_COMPARISONS, exemptedComparisons) : COUNTED_COMPARISONS;
        }

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (this.finalCountedComparisons.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    }
}

