/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterables;

public class HttpHeadersJsonDeserializer
extends JsonDeserializer<HttpHeaders> {
    @Override
    public HttpHeaders deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        return new HttpHeaders(Iterables.transform(HttpHeadersJsonDeserializer.all(rootNode.fields()), HttpHeadersJsonDeserializer.toHttpHeaders()));
    }

    private static Function<Map.Entry<String, JsonNode>, HttpHeader> toHttpHeaders() {
        return new Function<Map.Entry<String, JsonNode>, HttpHeader>(){

            @Override
            public HttpHeader apply(Map.Entry<String, JsonNode> field) {
                String key = field.getKey();
                if (field.getValue().isArray()) {
                    return new HttpHeader(key, (Collection<String>)ImmutableList.copyOf(Iterables.transform(HttpHeadersJsonDeserializer.all(field.getValue().elements()), HttpHeadersJsonDeserializer.toStringValues())));
                }
                return new HttpHeader(key, field.getValue().textValue());
            }
        };
    }

    private static Function<JsonNode, String> toStringValues() {
        return new Function<JsonNode, String>(){

            @Override
            public String apply(JsonNode node) {
                return node.textValue();
            }
        };
    }

    public static <T> Iterable<T> all(Iterator<T> underlyingIterator) {
        return () -> underlyingIterator;
    }
}

