/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            String schemaPathOfSchema = parentSchema.schemaPath + "/" + keyword;
            if (keyword.equals("if")) {
                foundIfSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        Set<String> backupEvaluatedProperties = CollectorContext.getInstance().copyEvaluatedProperties();
        Set<Object> ifEvaluatedProperties = Collections.emptySet();
        Set<Object> thenEvaluatedProperties = Collections.emptySet();
        Set<Object> elseEvaluatedProperties = Collections.emptySet();
        CollectorContext.getInstance().getEvaluatedProperties().clear();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        boolean ifConditionPassed = false;
        try {
            try {
                ifConditionPassed = this.ifSchema.validate(node, rootNode, at).isEmpty();
            }
            catch (JsonSchemaException ex) {
                ifConditionPassed = false;
            }
            ifEvaluatedProperties = CollectorContext.getInstance().copyEvaluatedProperties();
            if (ifConditionPassed && this.thenSchema != null) {
                CollectorContext.getInstance().getEvaluatedProperties().clear();
                errors.addAll(this.thenSchema.validate(node, rootNode, at));
                thenEvaluatedProperties = CollectorContext.getInstance().copyEvaluatedProperties();
            } else if (!ifConditionPassed && this.elseSchema != null) {
                CollectorContext.getInstance().getEvaluatedProperties().clear();
                errors.addAll(this.elseSchema.validate(node, rootNode, at));
                elseEvaluatedProperties = CollectorContext.getInstance().copyEvaluatedProperties();
            }
        }
        finally {
            CollectorContext.getInstance().replaceEvaluatedProperties(backupEvaluatedProperties);
            if (errors.isEmpty()) {
                if (ifConditionPassed) {
                    CollectorContext.getInstance().getEvaluatedProperties().addAll(ifEvaluatedProperties);
                }
                CollectorContext.getInstance().getEvaluatedProperties().addAll(thenEvaluatedProperties);
                CollectorContext.getInstance().getEvaluatedProperties().addAll(elseEvaluatedProperties);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }
}

