/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Optional;

public class JettySettings {
    private final Optional<Integer> acceptors;
    private final Optional<Integer> acceptQueueSize;

    private JettySettings(Optional<Integer> acceptors, Optional<Integer> acceptQueueSize) {
        this.acceptors = acceptors;
        this.acceptQueueSize = acceptQueueSize;
    }

    public Optional<Integer> getAcceptors() {
        return this.acceptors;
    }

    public Optional<Integer> getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public String toString() {
        return "JettySettings{acceptors=" + this.acceptors + ", acceptQueueSize=" + this.acceptQueueSize + '}';
    }

    public static class Builder {
        private Integer acceptors;
        private Integer acceptQueueSize;

        private Builder() {
        }

        public static Builder aJettySettings() {
            return new Builder();
        }

        public Builder withAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
            return this;
        }

        public Builder withAcceptQueueSize(Integer acceptQueueSize) {
            this.acceptQueueSize = acceptQueueSize;
            return this;
        }

        public JettySettings build() {
            JettySettings jettySettings = new JettySettings(Optional.fromNullable((Object)this.acceptors), Optional.fromNullable((Object)this.acceptQueueSize));
            return jettySettings;
        }
    }
}

