/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty6;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty6.DelayableSocketConnector;
import com.github.tomakehurst.wiremock.jetty6.DelayableSslSocketConnector;
import com.github.tomakehurst.wiremock.jetty6.Jetty6HandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import java.util.HashMap;
import wiremock.com.google.common.collect.Maps;
import wiremock.org.mortbay.jetty.MimeTypes;
import wiremock.org.mortbay.jetty.Server;
import wiremock.org.mortbay.jetty.bio.SocketConnector;
import wiremock.org.mortbay.jetty.servlet.Context;
import wiremock.org.mortbay.jetty.servlet.DefaultServlet;
import wiremock.org.mortbay.jetty.servlet.ServletHolder;
import wiremock.org.mortbay.thread.QueuedThreadPool;

class Jetty6HttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final Server jettyServer = new Server();
    private final DelayableSocketConnector httpConnector;
    private final DelayableSslSocketConnector httpsConnector;

    Jetty6HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler, RequestDelayControl requestDelayControl) {
        QueuedThreadPool threadPool = new QueuedThreadPool(options.containerThreads());
        this.jettyServer.setThreadPool(threadPool);
        this.httpConnector = this.createHttpConnector(requestDelayControl, options.bindAddress(), options.portNumber(), options.jettySettings());
        this.jettyServer.addConnector(this.httpConnector);
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(requestDelayControl, options.httpsSettings(), options.jettySettings());
            this.jettyServer.addConnector(this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        Notifier notifier = options.notifier();
        this.addAdminContext(adminRequestHandler, notifier);
        this.addMockServiceContext(stubRequestHandler, options.filesRoot(), notifier);
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer != null && this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    private DelayableSocketConnector createHttpConnector(RequestDelayControl requestDelayControl, String bindAddress, int port, JettySettings jettySettings) {
        DelayableSocketConnector connector = new DelayableSocketConnector(requestDelayControl);
        connector.setHost(bindAddress);
        connector.setPort(port);
        connector.setHeaderBufferSize(8192);
        this.setJettySettings(jettySettings, connector);
        return connector;
    }

    private DelayableSslSocketConnector createHttpsConnector(RequestDelayControl requestDelayControl, HttpsSettings httpsSettings, JettySettings jettySettings) {
        DelayableSslSocketConnector connector = new DelayableSslSocketConnector(requestDelayControl);
        connector.setPort(httpsSettings.port());
        connector.setHeaderBufferSize(8192);
        connector.setKeystore(httpsSettings.keyStorePath());
        connector.setKeyPassword(httpsSettings.keyStorePassword());
        if (httpsSettings.hasTrustStore()) {
            connector.setTruststore(httpsSettings.trustStorePath());
            connector.setTrustPassword(httpsSettings.trustStorePassword());
        }
        connector.setNeedClientAuth(httpsSettings.needClientAuth());
        this.setJettySettings(jettySettings, connector);
        return connector;
    }

    private void setJettySettings(JettySettings jettySettings, SocketConnector connector) {
        if (jettySettings.getAcceptors().isPresent()) {
            connector.setAcceptors(jettySettings.getAcceptors().get());
        }
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(jettySettings.getAcceptQueueSize().get());
        }
    }

    private void addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, Notifier notifier) {
        Context mockServiceContext = new Context(this.jettyServer, "/");
        HashMap<String, String> initParams = Maps.newHashMap();
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.maxCacheSize", "0");
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.resourceBase", fileSource.getPath());
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.setInitParams(initParams);
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(Jetty6HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, 2);
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, 15);
        this.jettyServer.addHandler(mockServiceContext);
    }

    private void addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        Context adminContext = new Context(this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(Jetty6HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), adminRequestHandler);
        adminContext.setAttribute("Notifier", notifier);
        this.jettyServer.addHandler(adminContext);
    }
}

