/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestInterceptor;
import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.util.Args;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

