/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty6;

import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.jetty6.ActiveSocket;
import java.io.IOException;
import java.net.Socket;
import wiremock.org.mortbay.jetty.bio.SocketConnector;

class DelayableSocketConnector
extends SocketConnector {
    private final RequestDelayControl requestDelayControl;

    DelayableSocketConnector(RequestDelayControl requestDelayControl) {
        this.requestDelayControl = requestDelayControl;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket;
        block2: {
            socket = this._serverSocket.accept();
            try {
                this.requestDelayControl.delayIfRequired();
            }
            catch (InterruptedException e) {
                if (this.isStopping() || this.isStopped()) break block2;
                Thread.interrupted();
            }
        }
        this.configure(socket);
        SocketConnector.Connection connection = new SocketConnector.Connection(socket){

            @Override
            public void run() {
                ActiveSocket.set(socket);
                super.run();
                ActiveSocket.clear();
            }
        };
        connection.dispatch();
    }
}

