/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import wiremock.com.jayway.jsonpath.Criteria;

public abstract class Filter<T> {
    public static Filter filter(Criteria criteria) {
        return new MapFilter(criteria);
    }

    public List<T> doFilter(List<T> filterItems) {
        ArrayList<T> result = new ArrayList<T>();
        for (T filterItem : filterItems) {
            if (!this.accept(filterItem)) continue;
            result.add(filterItem);
        }
        return result;
    }

    public abstract boolean accept(T var1);

    public abstract Filter addCriteria(Criteria var1);

    private static class MapFilter
    extends FilterAdapter<Map<String, Object>> {
        private HashMap<String, Criteria> criteria = new LinkedHashMap<String, Criteria>();

        public MapFilter(Criteria criteria) {
            this.addCriteria(criteria);
        }

        @Override
        public MapFilter addCriteria(Criteria criteria) {
            Criteria existing = this.criteria.get(criteria.getKey());
            String key = criteria.getKey();
            if (existing == null) {
                this.criteria.put(key, criteria);
            } else {
                existing.andOperator(criteria);
            }
            return this;
        }

        @Override
        public boolean accept(Map<String, Object> map) {
            for (Criteria criterion : this.criteria.values()) {
                if (criterion.matches(map)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class FilterAdapter<T>
    extends Filter<T> {
        @Override
        public boolean accept(T obj) {
            return false;
        }

        @Override
        public Filter addCriteria(Criteria criteria) {
            throw new UnsupportedOperationException("can not add criteria to a FilterAdapter.");
        }
    }
}

