/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BasicAuthAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void matchesPreemptiveBasicAuthWhenCredentialAreCorrect() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/basic/auth/preemptive")).withBasicAuth("the-username", "thepassword").willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.getWithPreemptiveCredentials("/basic/auth/preemptive", wireMockServer.port(), "the-username", "thepassword");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotMatchPreemptiveBasicAuthWhenCredentialsAreIncorrect() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/basic/auth/preemptive")).withBasicAuth("the-username", "thepassword").willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.getWithPreemptiveCredentials("/basic/auth/preemptive", wireMockServer.port(), "the-username", "WRONG!!!");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matcheswhenBASICInHeaderIsAllUpperCase() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/basic/auth/case-insensitive")).withBasicAuth("tom", "secret").willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/basic/auth/case-insensitive", TestHttpHeader.withHeader("Authorization", "BASIC dG9tOnNlY3JldA==")).statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

