/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class BindAddressTest {
    private String localhost = "127.0.0.1";
    private String nonBindAddress;
    private WireMockServer wireMockServer;
    final HttpClient client = HttpClientFactory.createClient();

    @Before
    public void prepare() throws Exception {
        this.nonBindAddress = this.getIpAddressOtherThan(this.localhost);
        Assume.assumeFalse((String)("Impossible to validate the binding address. This machine has only a one Ip address [" + this.localhost + "]"), (this.nonBindAddress == null ? 1 : 0) != 0);
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().bindAddress(this.localhost).dynamicPort().dynamicHttpsPort());
        this.wireMockServer.start();
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/bind-test")).willReturn(WireMock.aResponse().withStatus(200)));
    }

    @After
    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    @Test
    public void shouldRespondInTheBindAddressOnlyOnHttp() throws Exception {
        this.executeGetIn(this.localhost);
        try {
            this.executeGetIn(this.nonBindAddress);
            Assert.fail((String)("Should not accept HTTP connection to [" + this.nonBindAddress + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void shouldRespondInTheBindAddressOnlyOnHttps() throws Exception {
        int localhostStatus = this.getStatusViaHttps(this.localhost);
        MatcherAssert.assertThat((Object)localhostStatus, (Matcher)Matchers.is((Object)200));
        try {
            this.getStatusViaHttps(this.nonBindAddress);
            Assert.fail((String)("Should not accept HTTPS connection to [" + this.nonBindAddress + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getStatusViaHttps(String host) throws Exception {
        HttpResponse localhostResponse = this.client.execute(RequestBuilder.get((String)("https://" + host + ":" + this.wireMockServer.httpsPort() + "/bind-test")).build());
        int status = localhostResponse.getStatusLine().getStatusCode();
        EntityUtils.consume((HttpEntity)localhostResponse.getEntity());
        return status;
    }

    private void executeGetIn(String address) {
        WireMockTestClient wireMockClient = new WireMockTestClient(this.wireMockServer.port(), address);
        WireMockResponse response = wireMockClient.get("/bind-test", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    private String getIpAddressOtherThan(String lopbackAddress) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netInterface : Collections.list(networkInterfaces)) {
            Enumeration<InetAddress> inetAddresses = netInterface.getInetAddresses();
            for (InetAddress address : Collections.list(inetAddresses)) {
                if (!(address instanceof Inet4Address) || address.getHostAddress().equals(lopbackAddress)) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }
}

