/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BrowserProxyAcceptanceTest {
    @ClassRule
    public static WireMockClassRule target = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
    @Rule
    public WireMockClassRule instanceRule = target;
    private WireMockServer proxy;
    private WireMockTestClient testClient;

    @Before
    public void addAResourceToProxy() {
        this.testClient = new WireMockTestClient(target.port());
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        this.proxy.start();
    }

    @After
    public void stopServer() {
        if (this.proxy.isRunning()) {
            this.proxy.stop();
        }
    }

    @Test
    public void canProxyHttp() {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/whatever")).willReturn(WireMock.aResponse().withBody("Got it")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(this.url("/whatever"), this.proxy.port()).content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void passesQueryParameters() {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/search?q=things&limit=10")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(this.url("/search?q=things&limit=10"), this.proxy.port()).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    private String url(String pathAndQuery) {
        return "http://localhost:" + target.port() + pathAndQuery;
    }
}

