/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

public class ConcurrentProxyingTest {
    @Rule
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort(), false);
    @Rule
    public WireMockRule target = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().usingFilesUnderDirectory(TestFiles.defaultTestFilesRoot()), false);
    WireMockTestClient client;

    @Test
    public void concurrent() throws Exception {
        this.client = new WireMockTestClient(this.wm.port());
        this.wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.target.port())));
        ExecutorService executor = Executors.newFixedThreadPool(20);
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            results.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    MatcherAssert.assertThat((Object)ConcurrentProxyingTest.this.client.get("/plain-example1.txt", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Example 1"));
                    MatcherAssert.assertThat((Object)ConcurrentProxyingTest.this.client.get("/plain-example2.txt", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Example 2"));
                    MatcherAssert.assertThat((Object)ConcurrentProxyingTest.this.client.get("/plain-example3.txt", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Example 3"));
                    MatcherAssert.assertThat((Object)ConcurrentProxyingTest.this.client.get("/plain-example4.txt", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Example 4"));
                    MatcherAssert.assertThat((Object)ConcurrentProxyingTest.this.client.get("/plain-example5.txt", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Example 5"));
                }
            }));
        }
        for (Future result : results) {
            result.get();
        }
    }
}

