/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class DeadlockTest {
    private static final int READ_TIMEOUT = 500;
    private static WireMockServer wireMockServer;

    @BeforeClass
    public static void setUp() {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
        wireMockServer.start();
    }

    @AfterClass
    public static void tearDown() {
        wireMockServer.stop();
    }

    @Before
    public void reset() {
        System.out.println("reset");
        wireMockServer.resetAll();
    }

    @Test
    public void test1Timeout() throws IOException {
        System.out.println("test timeout start");
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/timeout")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(1000)).withBody("body1")));
        this.downloadContentAndMeasure("/timeout", null);
        System.out.println("test timeout end");
    }

    @Test
    public void test2GetContent() throws IOException {
        System.out.println("test content start");
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/content")).willReturn(WireMock.aResponse().withBody("body2")));
        System.out.println("test content stub");
        this.downloadContentAndMeasure("/content", "body2");
        System.out.println("test content end");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadContentAndMeasure(String urlDir, String expectedBody) throws IOException {
        System.out.printf("downloadContentAndMeasure urlDir=%s", urlDir);
        long start = System.currentTimeMillis();
        boolean exceptionOccurred = false;
        try {
            String url = "http://localhost:" + wireMockServer.port() + urlDir;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(500);
            connection.setDoInput(true);
            if (expectedBody == null) {
                try {
                    this.httpGetContent(connection);
                    Assert.fail((String)"Expected SocketTimeoutException");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(SocketTimeoutException.class));
                }
            } else {
                String body = this.httpGetContent(connection);
                Assert.assertEquals((Object)expectedBody, (Object)body);
            }
            if (exceptionOccurred) return;
        }
        catch (Exception e) {
            try {
                exceptionOccurred = true;
                System.out.printf("exception '%s' after ms %s", e.getMessage(), TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
                throw e;
            }
            catch (Throwable throwable) {
                if (exceptionOccurred) throw throwable;
                System.out.printf("downloaded at ms %s", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
                throw throwable;
            }
        }
        System.out.printf("downloaded at ms %s", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        return;
    }

    private String httpGetContent(HttpURLConnection connection) throws IOException {
        try (InputStream is = connection.getInputStream();){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
    }
}

