/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DebugHeadersAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void returnsMatchedStubIdHeaderWhenStubMatched() {
        UUID stubId = UUID.randomUUID();
        wireMockServer.stubFor(WireMock.get((String)"/the-match").withId(stubId).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.get("/the-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Id"), (Matcher)Matchers.is((Object)stubId.toString()));
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Name"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void returnsMatchedStubNameHeaderWhenNamedStubMatched() {
        UUID stubId = UUID.randomUUID();
        String name = "My Stub";
        wireMockServer.stubFor(WireMock.get((String)"/the-match").withId(stubId).withName(name).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.get("/the-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Id"), (Matcher)Matchers.is((Object)stubId.toString()));
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Name"), (Matcher)Matchers.is((Object)name));
    }

    @Test
    public void doesNotReturnEitherHeaderIfNoStubMatched() {
        WireMockResponse response = testClient.get("/the-non-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Id"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.firstHeader("Matched-Stub-Name"), (Matcher)Matchers.nullValue());
    }
}

