/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

public class DelayAndCustomMatcherAcceptanceTest {
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().extensions(new Class[]{BodyChanger.class}));

    @Test
    public void delayIsAddedWhenCustomResponseTransformerPresent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delay-this")).willReturn(WireMock.aResponse().withStatus(200).withTransformers(new String[]{"response-body-changer"}).withUniformRandomDelay(500, 1000)));
        WireMockTestClient client = new WireMockTestClient(this.wireMockRule.port());
        Stopwatch stopwatch = Stopwatch.createStarted();
        WireMockResponse response = client.get("/delay-this", new TestHttpHeader[0]);
        stopwatch.stop();
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Transformed body"));
    }

    public static class BodyChanger
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withBody("Transformed body").build();
        }

        public boolean applyGlobally() {
            return false;
        }

        public String getName() {
            return "response-body-changer";
        }
    }
}

