/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class GlobalSettingsAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void settingGlobalFixedResponseDelay() {
        WireMock.setGlobalFixedDelay((int)500);
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/globally/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200)));
        long start = System.currentTimeMillis();
        testClient.get("/globally/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(500)));
    }

    @Test
    public void settingGlobalRandomDistributionDelayCausesADelay() {
        WireMock.setGlobalRandomDelay((DelayDistribution)new LogNormal(90.0, 0.1));
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/globally/random/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200)));
        long start = System.currentTimeMillis();
        testClient.get("/globally/random/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(60)));
    }

    @Test
    public void canCombineFixedAndRandomDelays() {
        WireMock.setGlobalRandomDelay((DelayDistribution)new LogNormal(90.0, 0.1));
        WireMock.setGlobalFixedDelay((int)30);
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/globally/random/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200)));
        long start = System.currentTimeMillis();
        testClient.get("/globally/random/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(90)));
    }

    @Test
    public void fetchSettings() {
        WireMock.setGlobalFixedDelay((int)30);
        GlobalSettings settings = WireMock.getSettings();
        MatcherAssert.assertThat((Object)settings.getFixedDelay(), (Matcher)Matchers.is((Object)30));
    }

    @Test
    public void setAndRetrieveExtendedSettings() {
        WireMock.updateSettings((GlobalSettings)GlobalSettings.builder().extended(Parameters.one((String)"mySetting", (Object)"setting-value")).build());
        GlobalSettings fetchedSettings = WireMock.getSettings();
        MatcherAssert.assertThat((Object)fetchedSettings.getExtended().getString("mySetting"), (Matcher)Matchers.is((Object)"setting-value"));
    }
}

