/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.jetty.util.Jetty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class GzipAcceptanceTest {

    public static class GzipDisabled {
        @Rule
        public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().gzipDisabled(true));
        WireMockTestClient testClient;

        @Before
        public void init() {
            this.testClient = new WireMockTestClient(this.wm.port());
        }

        @Test
        public void doesNotGzipWhenDisabledInConfiguration() {
            String url = "/no-gzip-response";
            String bodyText = "body text";
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.ok((String)bodyText)));
            WireMockResponse response = this.testClient.get(url, TestHttpHeader.withHeader("Accept-Encoding", "gzip,deflate"));
            MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.headers().containsKey((Object)"Content-Encoding"), (Matcher)Matchers.is((Object)false));
            String plainText = response.content();
            MatcherAssert.assertThat((Object)plainText, (Matcher)Matchers.is((Object)bodyText));
        }
    }

    public static class NoChunkedTransferEncoding {
        @Rule
        public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().useChunkedTransferEncoding(Options.ChunkedEncodingPolicy.NEVER));
        WireMockTestClient testClient;

        @Before
        public void init() {
            this.testClient = new WireMockTestClient(this.wm.port());
        }

        @Test
        public void returnsContentLengthHeaderWhenChunkedEncodingDisabled() {
            Assume.assumeTrue((boolean)this.isNotOldJettyVersion());
            String bodyText = RandomStringUtils.randomAlphabetic((int)257);
            this.wm.stubFor(WireMock.get((String)"/gzip-response").willReturn(WireMock.ok((String)bodyText)));
            WireMockResponse response = this.testClient.get("/gzip-response", TestHttpHeader.withHeader("Accept-Encoding", "gzip,deflate"));
            MatcherAssert.assertThat((Object)response.firstHeader("Content-Encoding"), (Matcher)Matchers.is((Object)"gzip"));
            MatcherAssert.assertThat((Object)response.headers().containsKey((Object)"Transfer-Encoding"), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.is((Object)String.valueOf(Gzip.gzip((String)bodyText).length)));
            byte[] gzippedContent = response.binaryContent();
            String plainText = Gzip.unGzipToString((byte[])gzippedContent);
            MatcherAssert.assertThat((Object)plainText, (Matcher)Matchers.is((Object)bodyText));
        }

        private boolean isNotOldJettyVersion() {
            return !Jetty.VERSION.contains("9.2.");
        }
    }

    public static class ChunkedTransferEncoding
    extends AcceptanceTestBase {
        @Test
        public void servesGzippedResponseForGet() {
            wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/gzip-response")).willReturn(WireMock.aResponse().withBody("body text")));
            WireMockResponse response = testClient.get("/gzip-response", TestHttpHeader.withHeader("Accept-Encoding", "gzip,deflate"));
            MatcherAssert.assertThat((Object)response.firstHeader("Content-Encoding"), (Matcher)Matchers.is((Object)"gzip"));
            MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)"chunked"));
            MatcherAssert.assertThat((Object)response.headers().containsKey((Object)"Content-Length"), (Matcher)Matchers.is((Object)false));
            byte[] gzippedContent = response.binaryContent();
            String plainText = Gzip.unGzipToString((byte[])gzippedContent);
            MatcherAssert.assertThat((Object)plainText, (Matcher)Matchers.is((Object)"body text"));
        }

        @Test
        public void servesGzippedResponseForPost() throws Exception {
            wireMockServer.stubFor(WireMock.post((String)"/gzip-response").willReturn(WireMock.ok((String)"body text")));
            WireMockResponse response = testClient.post("/gzip-response", (HttpEntity)new StringEntity(""), TestHttpHeader.withHeader("Accept-Encoding", "gzip,deflate"));
            MatcherAssert.assertThat((Object)response.firstHeader("Content-Encoding"), (Matcher)Matchers.is((Object)"gzip"));
            byte[] gzippedContent = response.binaryContent();
            String plainText = Gzip.unGzipToString((byte[])gzippedContent);
            MatcherAssert.assertThat((Object)plainText, (Matcher)Matchers.is((Object)"body text"));
        }

        @Test
        public void acceptsGzippedRequest() {
            wireMockServer.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/gzip-request")).withRequestBody((ContentPattern)WireMock.equalTo((String)"request body")).willReturn(WireMock.aResponse().withBody("response body")));
            GzipCompressingEntity compressedBody = new GzipCompressingEntity((HttpEntity)new StringEntity("request body", ContentType.TEXT_PLAIN));
            WireMockResponse response = testClient.post("/gzip-request", (HttpEntity)compressedBody, new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"response body"));
        }
    }
}

