/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpsAcceptanceTest {
    private WireMockServer wireMockServer;
    private WireMockServer proxy;
    private HttpClient httpClient;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @After
    public void serverShutdown() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
        if (this.proxy != null) {
            this.proxy.shutdown();
        }
    }

    @Test
    public void shouldReturnStubOnSpecifiedPort() throws Exception {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void shouldReturnOnlyOnHttpsWhenHttpDisabled() throws Exception {
        this.exceptionRule.expect(IllegalStateException.class);
        this.exceptionRule.expectMessage("Not listening on HTTP port. Either HTTP is not enabled or the WireMock server is stopped.");
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().httpDisabled(true).dynamicHttpsPort();
        this.wireMockServer = new WireMockServer((Options)config);
        this.wireMockServer.start();
        WireMock.configureFor((String)"https", (String)"localhost", (int)this.wireMockServer.httpsPort());
        this.httpClient = HttpClientFactory.createClient();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        this.wireMockServer.port();
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void connectionResetByPeerFault() throws IOException {
        Assume.assumeFalse((String)"This feature does not work on Windows because of differing native socket behaviour", (boolean)SystemUtils.IS_OS_WINDOWS);
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/connection/reset")).willReturn(WireMock.aResponse().withFault(Fault.CONNECTION_RESET_BY_PEER)));
        this.exception.expect(SocketException.class);
        this.exception.expectMessage("Connection reset");
        this.httpClient.execute((HttpUriRequest)new HttpGet(this.url("/connection/reset"))).getEntity();
    }

    @Test
    public void emptyResponseFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/empty/response")).willReturn(WireMock.aResponse().withFault(Fault.EMPTY_RESPONSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/empty/response"), NoHttpResponseException.class);
    }

    @Test
    public void malformedResponseChunkFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/malformed/response")).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/malformed/response"), MalformedChunkCodingException.class);
    }

    @Test
    public void randomDataOnSocketFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/random/data")).willReturn(WireMock.aResponse().withFault(Fault.RANDOM_DATA_THEN_CLOSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/random/data"), ProtocolException.class);
    }

    @Test(expected=Exception.class)
    public void throwsExceptionWhenBadAlternativeKeystore() {
        String testKeystorePath = Resources.getResource((String)"bad-keystore").toString();
        this.startServerWithKeystore(testKeystorePath);
    }

    @Test
    public void acceptsAlternativeKeystore() throws Exception {
        String testKeystorePath = Resources.getResource((String)"test-keystore").toString();
        this.startServerWithKeystore(testKeystorePath);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void acceptsAlternativeKeystoreWithNonDefaultPassword() throws Exception {
        String testKeystorePath = Resources.getResource((String)"test-keystore-pwd").toString();
        this.startServerWithKeystore(testKeystorePath, "nondefaultpass", "password");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void acceptsAlternativeKeystoreWithNonDefaultKeyManagerPassword() throws Exception {
        String keystorePath = Resources.getResource((String)"test-keystore-key-man-pwd").toString();
        this.startServerWithKeystore(keystorePath, "password", "anotherpassword");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/alt-password-https")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/alt-password-https")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void failsToStartWithAlternativeKeystoreWithWrongKeyManagerPassword() {
        try {
            String keystorePath = Resources.getResource((String)"test-keystore-key-man-pwd").toString();
            this.startServerWithKeystore(keystorePath, "password", "wrongpassword");
            Assert.fail((String)"Expected a SocketException or SSLHandshakeException to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.is((Object)FatalStartupException.class.getName()));
        }
    }

    @Test
    public void rejectsWithoutClientCertificate() {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        try {
            this.contentFor(this.url("/https-test"));
            Assert.fail((String)"Expected a SocketException or SSLHandshakeException to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)SocketException.class.getName()), (Matcher)Matchers.is((Object)SSLHandshakeException.class.getName())));
        }
    }

    @Test
    public void acceptWithClientCertificate() throws Exception {
        String testTrustStorePath = TestFiles.TRUST_STORE_PATH;
        String testClientCertPath = TestFiles.TRUST_STORE_PATH;
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, testTrustStorePath, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)HttpsAcceptanceTest.secureContentFor(this.url("/https-test"), testClientCertPath, "mytruststorepassword"), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void supportsProxyingWhenTargetRequiresClientCert() throws Exception {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(0).trustStorePath(TestFiles.TRUST_STORE_PATH).trustStorePassword("mytruststorepassword"));
        this.proxy.start();
        this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("https://localhost:" + this.wireMockServer.httpsPort())));
        HttpGet get = new HttpGet("http://localhost:" + this.proxy.port() + "/client-cert-proxy");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void proxyingFailsWhenTargetServiceRequiresClientCertificatesAndProxyDoesNotSend() throws Exception {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy-fail")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(0));
        this.proxy.start();
        this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy-fail")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("https://localhost:" + this.wireMockServer.httpsPort())));
        HttpGet get = new HttpGet("http://localhost:" + this.proxy.port() + "/client-cert-proxy-fail");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)500));
    }

    private String url(String path) {
        return String.format("https://localhost:%d%s", this.wireMockServer.httpsPort(), path);
    }

    private static String toPath(String resourcePath) {
        try {
            return new File(Resources.getResource((String)resourcePath).toURI()).getCanonicalPath();
        }
        catch (Exception e) {
            return (String)Exceptions.throwUnchecked((Throwable)e, String.class);
        }
    }

    private void getAndAssertUnderlyingExceptionInstanceClass(String url, Class<?> expectedClass) {
        boolean thrown = false;
        try {
            this.contentFor(url);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            e.printStackTrace();
            if (cause != null) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(expectedClass));
            } else {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(expectedClass));
            }
            thrown = true;
        }
        Assert.assertTrue((String)"No exception was thrown", (boolean)thrown);
    }

    private String contentFor(String url) throws Exception {
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        return content;
    }

    private void startServerEnforcingClientCert(String keystorePath, String truststorePath, String trustStorePassword) {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort();
        if (keystorePath != null) {
            config.keystorePath(keystorePath);
        }
        if (truststorePath != null) {
            config.trustStorePath(truststorePath);
            config.trustStorePassword(trustStorePassword);
            config.needClientAuth(true);
        }
        config.bindAddress("localhost");
        this.wireMockServer = new WireMockServer((Options)config);
        this.wireMockServer.start();
        WireMock.configureFor((String)"https", (String)"localhost", (int)this.wireMockServer.httpsPort());
        this.httpClient = HttpClientFactory.createClient();
    }

    private void startServerWithKeystore(String keystorePath, String keystorePassword, String keyManagerPassword) {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort();
        if (keystorePath != null) {
            config.keystorePath(keystorePath).keystorePassword(keystorePassword).keyManagerPassword(keyManagerPassword);
        }
        this.wireMockServer = new WireMockServer((Options)config);
        this.wireMockServer.start();
        WireMock.configureFor((int)this.wireMockServer.port());
        this.httpClient = HttpClientFactory.createClient();
    }

    private void startServerWithKeystore(String keystorePath) {
        this.startServerWithKeystore(keystorePath, "password", "password");
    }

    private void startServerWithDefaultKeystore() {
        this.startServerWithKeystore(null);
    }

    static String secureContentFor(String url, String clientTrustStore, String trustStorePassword) throws Exception {
        KeyStore trustStore = HttpsAcceptanceTest.readKeyStore(clientTrustStore, trustStorePassword);
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(trustStore, trustStorePassword.toCharArray()).setKeyStoreType("pkcs12").setProtocol("TLS").build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        return content;
    }

    static KeyStore readKeyStore(String path, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(path);){
            trustStore.load(instream, password.toCharArray());
        }
        return trustStore;
    }
}

