/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;

public class LogTimingAcceptanceTest
extends AcceptanceTestBase {
    @BeforeClass
    public static void setupServer() {
        LogTimingAcceptanceTest.setupServer(WireMockConfiguration.options().asynchronousResponseEnabled(true).asynchronousResponseThreads(5));
    }

    @Test
    public void serveEventIncludesTotalAndServeDuration() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/time-me").willReturn(WireMock.ok()));
        for (int i = 0; i < 2500; ++i) {
            WireMock.stubFor((MappingBuilder)WireMock.get((String)("/time-me/" + i)).willReturn(WireMock.ok()));
        }
        testClient.get("/time-me", new TestHttpHeader[0]);
        ServeEvent serveEvent = (ServeEvent)WireMock.getAllServeEvents().get(0);
        MatcherAssert.assertThat((Object)serveEvent.getTiming().getServeTime(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)serveEvent.getTiming().getTotalTime(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void includesAddedDelayInTotalWhenAsync() {
        int DELAY = 500;
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/time-me/async").withRequestBody((ContentPattern)WireMock.equalToXml((String)"<value>1111</value>")).willReturn(WireMock.ok().withFixedDelay(Integer.valueOf(500))));
        for (int i = 0; i < 500; ++i) {
            WireMock.stubFor((MappingBuilder)WireMock.post((String)"/time-me/async").withRequestBody((ContentPattern)WireMock.equalToXml((String)("<value>123456" + i + " </value>"))).willReturn(WireMock.ok()));
        }
        testClient.postXml("/time-me/async", "<value>1111</value>", new TestHttpHeader[0]);
        ServeEvent serveEvent = (ServeEvent)WireMock.getAllServeEvents().get(0);
        Timing timing = serveEvent.getTiming();
        MatcherAssert.assertThat((Object)timing.getAddedDelay(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)timing.getProcessTime(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)timing.getServeTime(), (Matcher)Matchers.is((Object)(timing.getProcessTime() + timing.getResponseSendTime())));
        MatcherAssert.assertThat((Object)timing.getTotalTime(), (Matcher)Matchers.is((Object)(timing.getProcessTime() + timing.getResponseSendTime() + 500)));
    }
}

