/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.testsupport.MappingJsonSamples;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MappingsAcceptanceTest
extends AcceptanceTestBase {
    @BeforeClass
    public static void setupServer() {
        MappingsAcceptanceTest.setupServerWithMappingsInFileRoot();
    }

    @Test
    public void basicMappingCheckNonUtf8() {
        testClient.addResponse("{                                                                                                                      \n   \"request\": {                                                                                      \n           \"method\": \"GET\",                                                                \n           \"url\": \"/test/nonutf8/\"                         \n   },                                                                                                                  \n   \"response\": {                                                                                     \n           \"status\": 200,                                                                            \n           \"headers\": {                                                    \n               \"Content-type\": \"text/plain; charset=GB2312\"      \n           },                                                    \n           \"body\": \"\u56fd\u5bb6\u6807\u51c6\"                       \n   }                                                                                          \n}\n", "GB2312");
        WireMockResponse response = testClient.get("/test/nonutf8/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"\u56fd\u5bb6\u6807\u51c6"));
    }

    @Test
    public void basicMappingCheckCharsetMismatch() {
        testClient.addResponse("{                                                                                                                      \n   \"request\": {                                                                                      \n           \"method\": \"GET\",                                                                \n           \"url\": \"/test/nonutf8/\"                         \n   },                                                                                                                  \n   \"response\": {                                                                                     \n           \"status\": 200,                                                                            \n           \"headers\": {                                                    \n               \"Content-type\": \"text/plain; charset=GB2312\"      \n           },                                                    \n           \"body\": \"\u56fd\u5bb6\u6807\u51c6\"                       \n   }                                                                                          \n}\n", "ISO-8859-8");
        WireMockResponse response = testClient.get("/test/nonutf8/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"????"));
    }

    @Test
    public void basicMappingWithExactUrlAndMethodMatchIsCreatedAndReturned() {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/a/registered/resource\"\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 401,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/plain\"\t\t\n\t\t},\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"body\": \"Not allowed!\"\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/a/registered/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Not allowed!"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void mappingWithStatusOnlyResponseIsCreatedAndReturned() {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"PUT\",\t\t\t\t\t\t\n\t\t\"url\": \"/status/only\"\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 204\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.put("/status/only", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
        Assert.assertNull((Object)response.content());
    }

    @Test
    public void notFoundResponseIsReturnedForUnregisteredUrl() {
        WireMockResponse response = testClient.get("/non-existent/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void multipleMappingsSupported() {
        this.add200ResponseFor("/resource/1");
        this.add200ResponseFor("/resource/2");
        this.add200ResponseFor("/resource/3");
        this.getResponseAndAssert200Status("/resource/1");
        this.getResponseAndAssert200Status("/resource/2");
        this.getResponseAndAssert200Status("/resource/3");
    }

    @Test
    public void multipleInvocationsSupported() {
        this.add200ResponseFor("/resource/100");
        this.getResponseAndAssert200Status("/resource/100");
        this.getResponseAndAssert200Status("/resource/100");
        this.getResponseAndAssert200Status("/resource/100");
    }

    @Test
    public void loadsDefaultMappingsOnStart() {
        this.getResponseAndAssert200Status("/testmapping");
    }

    @Test
    public void resetToDefaultRemovesAllButDefault() {
        this.add200ResponseFor("/resource/11");
        testClient.resetDefaultMappings();
        this.getResponseAndAssert404Status("/resource/11");
        this.getResponseAndAssert200Status("/testmapping");
    }

    @Test
    public void resetToDefaultRestoresOldMeaningOfDefault() {
        this.add200ResponseFor("/testmapping");
        WireMockResponse response1 = testClient.get("/testmapping", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response1.content(), (Matcher)Matchers.is((Object)""));
        testClient.resetDefaultMappings();
        WireMockResponse response2 = testClient.get("/testmapping", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response2.content(), (Matcher)Matchers.is((Object)"default test mapping"));
    }

    @Test
    public void readsMapppingForByteBody() {
        testClient.addResponse(MappingJsonSamples.MAPPING_REQUEST_FOR_BYTE_BODY);
        MatcherAssert.assertThat((Object)testClient.get("/byte/resource/from/file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"ABC"));
    }

    @Test
    public void readsMapppingForByteBodyReturnsByteArray() {
        testClient.addResponse(MappingJsonSamples.MAPPING_REQUEST_FOR_BINARY_BYTE_BODY);
        MatcherAssert.assertThat((Object)testClient.get("/bytecompressed/resource/from/file", new TestHttpHeader[0]).binaryContent(), (Matcher)Matchers.is((Object)MappingJsonSamples.BINARY_COMPRESSED_CONTENT));
    }

    @Test
    public void readsJsonMapping() {
        WireMockResponse response = testClient.get("/testjsonmapping", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{\"key\":\"value\",\"array\":[1,2,3]}"));
    }

    @Test
    public void appendsTransferEncodingHeaderIfNoContentLengthHeaderIsPresentInMapping() throws Exception {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/with/body\"\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"body\": \"Some content\"\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/with/body", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)"chunked"));
    }

    @Test
    public void responseContainsContentLengthAndChunkedEncodingHeadersIfItIsDefinedInTheMapping() throws Exception {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/with/body\"\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Length\": \"12\"\t\t        \n\t\t},\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"body\": \"Some content\"\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/with/body", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.is((Object)"12"));
        Assert.assertFalse((String)"expected Transfer-Encoding head to be absent", (boolean)response.headers().containsKey((Object)"Transfer-Encoding"));
    }

    private void getResponseAndAssert200Status(String url) {
        WireMockResponse response = testClient.get(url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    private void getResponseAndAssert404Status(String url) {
        WireMockResponse response = testClient.get(url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    private void add200ResponseFor(String url) {
        testClient.addResponse(String.format("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"urlPattern\": \"%s\"\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t", url));
    }
}

