/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.testsupport.MultipartBody;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MultipartBodyMatchingAcceptanceTest
extends AcceptanceTestBase {
    HttpClient httpClient = HttpClientFactory.createClient();

    @Test
    public void acceptsAMultipartRequestContainingATextAndAFilePart() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart").withMultipartRequestBody(WireMock.aMultipart().withName("text").withBody((ContentPattern)WireMock.containing((String)"hello"))).withMultipartRequestBody(WireMock.aMultipart().withName("file").withBody((ContentPattern)WireMock.binaryEqualTo((byte[])"ABCD".getBytes()))).willReturn(WireMock.ok()));
        HttpUriRequest request = RequestBuilder.post((String)(wireMockServer.baseUrl() + "/multipart")).setEntity(MultipartEntityBuilder.create().addTextBody("text", "hello").addBinaryBody("file", "ABCD".getBytes()).build()).build();
        HttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((String)EntityUtils.toString((HttpEntity)response.getEntity()), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void handlesAbsenceOfPartsInAMultipartRequest() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/empty-multipart").withMultipartRequestBody(WireMock.aMultipart().withName("bits").withBody((ContentPattern)WireMock.matching((String)".*"))).willReturn(WireMock.ok()));
        HttpUriRequest request = RequestBuilder.post((String)(wireMockServer.baseUrl() + "/empty-multipart")).setHeader("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW").setEntity((HttpEntity)new StringEntity("", ContentType.MULTIPART_FORM_DATA)).build();
        HttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotFailWithMultipartMixedRequest() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart-mixed").willReturn(WireMock.ok()));
        HttpUriRequest request = RequestBuilder.post((String)(wireMockServer.baseUrl() + "/multipart-mixed")).setHeader("Content-Type", "multipart/mixed; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW").setEntity((HttpEntity)new StringEntity("", ContentType.create((String)"multipart/mixed"))).build();
        HttpResponse response = this.httpClient.execute(request);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void multipartBodiesCanBeMatchedWhenStubsWithOtherBodyMatchTypesArePresent() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/multipart").withMultipartRequestBody(WireMock.aMultipart().withHeader("Content-Disposition", WireMock.containing((String)"wiremocktest"))).willReturn(WireMock.ok()));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/json").withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"stuff\": 123 }")).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postWithMultiparts("/multipart", Collections.singletonList(MultipartBody.part("wiremocktest", "Whatever", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

