/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultithreadConfigurationInheritanceTest {
    private static WireMockServer wireMockServer;
    private static WireMockTestClient client;

    @BeforeClass
    public static void setup() {
        wireMockServer = new WireMockServer(0);
        wireMockServer.start();
        WireMock.configureFor((int)wireMockServer.port());
        client = new WireMockTestClient(wireMockServer.port());
    }

    @AfterClass
    public static void shutdown() {
        wireMockServer.shutdown();
    }

    @Test(timeout=5000L)
    public void verifyConfigurationInherited() {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/foo/bar")).willReturn(WireMock.aResponse().withStatus(200)));
        client.get("/foo/bar", new TestHttpHeader[0]);
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/foo/bar")));
    }
}

