/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import ignored.ManyUnmatchedRequestsTest;
import ignored.SingleUnmatchedRequestTest;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunWith(value=Enclosed.class)
public class NearMissesRuleAcceptanceTest {

    public static class CustomMatcherWithNearMissesTest {
        @ClassRule
        public static WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory("src/main/resources/empty").extensions(new Extension[]{new RequestMatcherExtension(){

            public MatchResult match(Request request, Parameters parameters) {
                return MatchResult.partialMatch((double)0.5);
            }

            public String getName() {
                return "always-match";
            }
        }}), false);
        WireMockTestClient client;

        @Before
        public void init() {
            this.client = new WireMockTestClient(wm.port());
            wm.resetAll();
        }

        @Test
        public void successfullyCalculatesNearMissesWhenACustomMatcherIsRegistered() {
            wm.stubFor(WireMock.requestMatching((String)"always-match").willReturn(WireMock.aResponse()));
            this.client.get("/", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)wm.findNearMissesForAllUnmatchedRequests().size(), (Matcher)Matchers.is((Object)1));
        }
    }

    public static class NearMissesRuleTest {
        static TestNotifier testNotifier = new TestNotifier();
        @Rule
        public ExpectedException thrown = ExpectedException.none();
        @ClassRule
        public static WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)testNotifier).withRootDirectory("src/main/resources/empty"), false);
        WireMockTestClient client;

        @Before
        public void init() {
            this.client = new WireMockTestClient(wm.port());
            testNotifier.reset();
            wm.resetAll();
        }

        @Test
        public void logsUnmatchedRequestsAtErrorWithNearMisses() throws Exception {
            wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/near-miss")).willReturn(WireMock.aResponse().withStatus(200)));
            wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/miss")).willReturn(WireMock.aResponse().withStatus(200)));
            this.client.post("/a-near-mis", (HttpEntity)new StringEntity(""), new TestHttpHeader[0]);
            MatcherAssert.assertThat(testNotifier.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Request was not matched"), (Matcher)Matchers.containsString((String)"/a-near-mis"), (Matcher)Matchers.containsString((String)"/near-miss"), (Matcher)Matchers.containsString((String)"HTTP method does not match"), (Matcher)Matchers.containsString((String)"URL does not match"))));
        }

        @Test
        public void throwsVerificationExceptionIfSomeRequestsWentUnmatched() {
            String message = NearMissesRuleTest.runTestAndGetMessage(ManyUnmatchedRequestsTest.class);
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"2 requests were unmatched by any stub mapping"));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/near-misssss\n")));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/a-near-mis\n")));
        }

        @Test
        public void throwsVerificationExceptionIfASingleRequestWentUnmatched() {
            String message = NearMissesRuleTest.runTestAndGetMessage(SingleUnmatchedRequestTest.class);
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"A request was unmatched by any stub mapping. Closest stub mapping was:"));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/near-misssss\n")));
        }

        @Test
        public void shouldFindNearMatch() {
            this.thrown.expect(VerificationException.class);
            this.thrown.expectMessage("No requests exactly matched. Most similar request was:");
            this.client.get("/123", new TestHttpHeader[0]);
            wm.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/")));
        }

        private static String runTestAndGetMessage(Class<?> testClass) {
            final AtomicReference<String> message = new AtomicReference<String>("");
            JUnitCore junit = new JUnitCore();
            junit.addListener(new RunListener(){

                public void testFailure(Failure failure) throws Exception {
                    message.set(failure.getMessage());
                }
            });
            junit.run(new Class[]{testClass});
            return message.get();
        }
    }
}

