/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.requestfilter.FieldTransformer;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.extension.requestfilter.StubRequestFilter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class NotMatchedPageAcceptanceTest {
    WireMockServer wm;
    WireMockTestClient testClient;

    @After
    public void stop() {
        this.wm.stop();
    }

    @Test
    public void rendersAPlainTextDiffWhenStubNotMatchedAndANearMissIsAvailable() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("X-My-Header", WireMock.containing((String)"correct value")).withHeader("Accept", WireMock.matching((String)"text/plain.*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{                              \n    \"thing\": {               \n        \"stuff\": [1, 2, 3]   \n    }                          \n}")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.postJson("/thin", "{                        \n    \"thing\": {           \n        \"nothing\": {}    \n    }                      \n}", TestHttpHeader.withHeader("X-My-Header", "wrong value"), TestHttpHeader.withHeader("Accept", "text/plain"));
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_ascii.txt")));
    }

    @Test
    public void adjustsWidthWhenConsoleWidthHeaderSpecified() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("X-My-Header", WireMock.containing((String)"correct value")).withHeader("Accept", WireMock.matching((String)"text/plain.*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{                              \n    \"thing\": {               \n        \"stuff\": [1, 2, 3]   \n    }                          \n}")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.postJson("/thin", "{                        \n    \"thing\": {           \n        \"nothing\": {}    \n    }                      \n}", TestHttpHeader.withHeader("X-My-Header", "wrong value"), TestHttpHeader.withHeader("Accept", "text/plain"), TestHttpHeader.withHeader("X-WireMock-Console-Width", "69"));
        System.out.println(response.content());
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_ascii-narrow.txt")));
    }

    @Test
    public void rendersAPlainTextDiffWhenRequestIsOnlyUrlAndMethod() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/another-url").withRequestBody((ContentPattern)WireMock.absent()).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/gettable", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void showsADefaultMessageWhenNoStubsWerePresent() {
        this.configure();
        WireMockResponse response = this.testClient.get("/no-stubs-to-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"No response could be served as there are no stub mappings in this WireMock instance."));
    }

    @Test
    public void supportsCustomNoMatchRenderer() {
        this.configure(WireMockConfiguration.wireMockConfig().notMatchedRenderer(new NotMatchedRenderer(){

            protected ResponseDefinition render(Admin admin, Request request) {
                return ResponseDefinitionBuilder.responseDefinition().withStatus(403).withBody("No you don't!").build();
            }
        }));
        WireMockResponse response = this.testClient.get("/should-not-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"No you don't!"));
    }

    @Test
    public void returns404AndDiffReportWhenPlusSymbolInQuery() {
        this.configure();
        WireMockResponse response = this.testClient.get("/some/api/records?sort=updated+asc&filter_updated_gt=2019-01-02", new TestHttpHeader[0]);
        System.err.println(response.content());
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"No response could be served"));
    }

    @Test
    public void indicatesWhenWrongScenarioStateIsTheReasonForNonMatch() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").inScenario("thing states").whenScenarioStateIs("first").willReturn(WireMock.ok((String)"Done!")));
        WireMockResponse response = this.testClient.postJson("/thing", "{}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_scenario-state.txt")));
    }

    @Test
    public void requestValuesTransformedByRequestFilterAreShownInDiff() {
        this.configure(WireMockConfiguration.wireMockConfig().extensions(new Extension[]{new StubRequestFilter(){

            public RequestFilterAction filter(Request request) {
                Request wrappedRequest = RequestWrapper.create().transformHeader("X-My-Header", (FieldTransformer)new FieldTransformer<List<String>>(){

                    public List<String> transform(List<String> source) {
                        return Collections.singletonList("modified value");
                    }
                }).wrap(request);
                return RequestFilterAction.continueWith((Request)wrappedRequest);
            }

            public String getName() {
                return "thing-changer-filter";
            }
        }}));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/filter").withHeader("X-My-Header", WireMock.equalTo((String)"original value")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/filter", TestHttpHeader.withHeader("X-My-Header", "original value"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"| X-My-Header: modified value"));
    }

    private void configure() {
        this.configure(WireMockConfiguration.wireMockConfig().dynamicPort());
    }

    private void configure(WireMockConfiguration options) {
        options.dynamicPort().withRootDirectory("src/test/resources/empty");
        this.wm = new WireMockServer((Options)options);
        this.wm.start();
        this.testClient = new WireMockTestClient(this.wm.port());
        WireMock.configureFor((int)this.wm.port());
    }
}

