/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.testsupport.Network;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PortNumberTest {
    private List<WireMockServer> createdServers;

    @Before
    public void setup() {
        this.createdServers = new ArrayList<WireMockServer>();
    }

    @After
    public void stopServers() {
        for (WireMockServer wireMockServer : this.createdServers) {
            if (!wireMockServer.isRunning()) continue;
            wireMockServer.stop();
        }
    }

    @Test
    public void canRunOnAnotherPortThan8080() {
        int port = Network.findFreePort();
        WireMockServer wireMockServer = this.createServer(WireMockConfiguration.wireMockConfig().port(port));
        wireMockServer.start();
        WireMockTestClient wireMockClient = new WireMockTestClient(port);
        wireMockClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/a/registered/resource\"\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 401,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/plain\"\t\t\n\t\t},\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"body\": \"Not allowed!\"\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = wireMockClient.get("/a/registered/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void configuredPortIsReportedListeningPort() {
        int port = Network.findFreePort();
        int httpsPort = Network.findFreePort();
        WireMockServer wireMockServer = this.createServer(WireMockConfiguration.wireMockConfig().port(port).httpsPort(Integer.valueOf(httpsPort)));
        wireMockServer.start();
        MatcherAssert.assertThat((Object)wireMockServer.port(), (Matcher)Matchers.is((Object)port));
        MatcherAssert.assertThat((Object)wireMockServer.httpsPort(), (Matcher)Matchers.is((Object)httpsPort));
    }

    @Test(expected=IllegalStateException.class)
    public void unstartedServerThrowsExceptionWhenAttemptingToRetrievePort() {
        this.createServer(WireMockConfiguration.wireMockConfig().port(Network.findFreePort())).port();
    }

    @Test(expected=IllegalStateException.class)
    public void unstartedServerThrowsExceptionWhenAttemptingToRetrieveHttpsPort() {
        this.createServer(WireMockConfiguration.wireMockConfig().httpsPort(Integer.valueOf(Network.findFreePort()))).httpsPort();
    }

    @Test(expected=IllegalStateException.class)
    public void serverWithoutHttpsThrowsExceptionWhenAttemptingToRetrieveHttpsPort() {
        WireMockServer wireMockServer = this.createServer(WireMockConfiguration.wireMockConfig().port(Network.findFreePort()));
        wireMockServer.start();
        wireMockServer.httpsPort();
    }

    @Test
    public void configuringPortZeroPicksArbitraryPort() {
        WireMockServer wireMockServer = this.createServer(WireMockConfiguration.wireMockConfig().port(0).httpsPort(Integer.valueOf(0)));
        wireMockServer.start();
        MatcherAssert.assertThat((Object)wireMockServer.port(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)wireMockServer.httpsPort(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private WireMockServer createServer(WireMockConfiguration configuration) {
        WireMockServer wireMockServer = new WireMockServer((Options)configuration);
        this.createdServers.add(wireMockServer);
        return wireMockServer;
    }
}

