/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.MoreObjects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class PostServeActionExtensionTest {
    WireMockServer wm;
    WireMockTestClient client;

    void initWithOptions(Options options) {
        this.wm = new WireMockServer(options);
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    @After
    public void cleanup() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    @Test
    public void triggersActionWhenAppliedToAStubMapping() throws Exception {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new NamedCounterAction()}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/count-me")).withPostServeAction("count-request", (Object)CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse()));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/things"), Matchers.is((Object)"4"));
    }

    @Test
    public void continuesWithNoEffectIfANonExistentActionIsReferenced() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort());
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/as-normal")).withPostServeAction("does-not-exist", (Object)CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/as-normal", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void providesServeEventWithResponseFieldPopulated() throws InterruptedException {
        final AtomicInteger finalStatus = new AtomicInteger();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new PostServeAction(){

            public String getName() {
                return "response-field-test";
            }

            public void doGlobalAction(ServeEvent serveEvent, Admin admin) {
                if (serveEvent.getResponse() != null) {
                    finalStatus.set(serveEvent.getResponse().getStatus());
                }
            }
        }}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/response-status")).willReturn(WireMock.aResponse().withStatus(418)));
        this.client.get("/response-status", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getValue(finalStatus), Matchers.is((Object)418));
    }

    private Callable<Integer> getValue(final AtomicInteger value) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return value.get();
            }
        };
    }

    private Callable<String> getContent(final String url) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return PostServeActionExtensionTest.this.client.get(url, new TestHttpHeader[0]).content();
            }
        };
    }

    public static class CounterNameParameter {
        public String counterName;

        public CounterNameParameter(@JsonProperty(value="counterName") String counterName) {
            this.counterName = counterName;
        }

        public CounterNameParameter() {
        }

        public static CounterNameParameter counterNameParameter() {
            return new CounterNameParameter();
        }

        public CounterNameParameter withName(String name) {
            this.counterName = name;
            return this;
        }
    }

    public static class NamedCounterAction
    extends PostServeAction
    implements AdminApiExtension {
        private final ConcurrentHashMap<String, Integer> counters = new ConcurrentHashMap();

        public String getName() {
            return "count-request";
        }

        public void contributeAdminApiRoutes(Router router) {
            router.add(RequestMethod.GET, "/named-counter/{name}", new AdminTask(){

                public ResponseDefinition execute(Admin admin, Request request, PathParams pathParams) {
                    String name = (String)pathParams.get((Object)"name");
                    Integer count = (Integer)MoreObjects.firstNonNull(NamedCounterAction.this.counters.get(name), (Object)0);
                    return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(String.valueOf(count)).build();
                }
            });
        }

        public void doAction(ServeEvent serveEvent, Admin admin, Parameters parameters) {
            Integer newValue;
            Integer oldValue;
            CounterNameParameter counterNameParam = (CounterNameParameter)parameters.as(CounterNameParameter.class);
            String counterName = counterNameParam.counterName;
            this.counters.putIfAbsent(counterName, 0);
            while (!this.counters.replace(counterName, oldValue = this.counters.get(counterName), newValue = Integer.valueOf(oldValue + 1))) {
            }
        }
    }
}

