/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ProxyAcceptanceTest {
    private String targetServiceBaseUrl;
    private String targetServiceBaseHttpsUrl;
    WireMockServer targetService;
    WireMock targetServiceAdmin;
    WireMockServer proxyingService;
    WireMock proxyingServiceAdmin;
    WireMockTestClient testClient;

    void init(WireMockConfiguration proxyingServiceOptions) {
        this.targetService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().bindAddress("127.0.0.1").stubCorsEnabled(true));
        this.targetService.start();
        this.targetServiceAdmin = WireMock.create().host("localhost").port(this.targetService.port()).build();
        this.targetServiceBaseUrl = "http://localhost:" + this.targetService.port();
        this.targetServiceBaseHttpsUrl = "https://localhost:" + this.targetService.httpsPort();
        proxyingServiceOptions.dynamicPort().bindAddress("127.0.0.1");
        this.proxyingService = new WireMockServer((Options)proxyingServiceOptions);
        this.proxyingService.start();
        this.proxyingServiceAdmin = WireMock.create().port(this.proxyingService.port()).build();
        this.testClient = new WireMockTestClient(this.proxyingService.port());
        WireMock.configureFor((int)this.targetService.port());
    }

    void initWithDefaultConfig() {
        this.init(WireMockConfiguration.wireMockConfig());
    }

    @After
    public void stop() {
        this.targetService.stop();
        this.proxyingService.stop();
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxy() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Proxied content"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyWhenInjectingAddtionalRequestHeaders() {
        this.initWithDefaultConfig();
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/additional/headers")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withAdditionalRequestHeader("a", "b").withAdditionalRequestHeader("c", "d")));
        this.testClient.get("/additional/headers", new TestHttpHeader[0]);
        this.targetServiceAdmin.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/additional/headers")).withHeader("a", WireMock.equalTo((String)"b")).withHeader("c", WireMock.equalTo((String)"d")));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyInjectingHeadersOverridingSentHeaders() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).withHeader("a", WireMock.equalTo((String)"b")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied content")));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withAdditionalRequestHeader("a", "b")));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", TestHttpHeader.withHeader("a", "doh"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Proxied content"));
    }

    @Test
    public void successfullyPostsResponseToOtherServiceViaProxy() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).willReturn(WireMock.aResponse().withStatus(204)));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.postWithBody("/proxied/resource", "Post content", "text/plain", "utf-8");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
        this.targetServiceAdmin.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).withRequestBody((ContentPattern)WireMock.matching((String)"Post content")));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyWithEscapeCharsInUrl() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/%26%26The%20Lord%20of%20the%20Rings%26%26", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void successfullyGetsResponseBinaryResponses() throws IOException {
        this.initWithDefaultConfig();
        final byte[] bytes = new byte[]{16, 73, 110, -73, 70, -26, 82, -107, -107, 66};
        HttpServer server = HttpServer.create(new InetSocketAddress(0), 0);
        server.createContext("/binary", new HttpHandler(){

            @Override
            public void handle(HttpExchange exchange) throws IOException {
                InputStream request = exchange.getRequestBody();
                byte[] buffy = new byte[10];
                request.read(buffy);
                if (Arrays.equals(buffy, bytes)) {
                    exchange.sendResponseHeaders(200, bytes.length);
                    OutputStream out = exchange.getResponseBody();
                    out.write(bytes);
                    out.close();
                } else {
                    exchange.sendResponseHeaders(500, 0L);
                    exchange.close();
                }
            }
        });
        server.start();
        this.proxyingServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/binary")).willReturn(WireMock.aResponse().proxiedFrom("http://localhost:" + server.getAddress().getPort()).withBody(bytes)));
        WireMockResponse post = this.testClient.post("/binary", (HttpEntity)new ByteArrayEntity(bytes), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)post.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)post.binaryContent(), (Matcher)Matchers.equalTo((Object)bytes));
    }

    @Test
    public void sendsContentLengthHeaderWhenPostingIfPresentInOriginalRequest() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).willReturn(WireMock.aResponse().withStatus(201)));
        this.proxyingServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.postWithBody("/with/length", "TEST", "application/x-www-form-urlencoded", "utf-8");
        this.targetServiceAdmin.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).withHeader("Content-Length", WireMock.equalTo((String)"4")));
    }

    @Test
    public void sendsTransferEncodingChunkedWhenPostingIfPresentInOriginalRequest() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).willReturn(WireMock.aResponse().withStatus(201)));
        this.proxyingServiceAdmin.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.postWithChunkedBody("/chunked", "TEST".getBytes());
        this.targetServiceAdmin.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).withHeader("Transfer-Encoding", WireMock.equalTo((String)"chunked")));
    }

    @Test
    public void preservesHostHeaderWhenSpecified() {
        this.init(WireMockConfiguration.wireMockConfig().preserveHostHeader(true));
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxyingServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/preserve-host-header", TestHttpHeader.withHeader("Host", "my.host"));
        this.proxyingServiceAdmin.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
        this.targetServiceAdmin.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
    }

    @Test
    public void usesProxyUrlBasedHostHeaderWhenPreserveHostHeaderNotSpecified() throws Exception {
        this.init(WireMockConfiguration.wireMockConfig().preserveHostHeader(false));
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxyingServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/host-header", TestHttpHeader.withHeader("Host", "my.host"));
        this.proxyingServiceAdmin.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
        this.targetServiceAdmin.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).withHeader("Host", WireMock.equalTo((String)("localhost:" + this.targetService.port()))));
    }

    @Test
    public void proxiesPatchRequestsWithBody() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.patch((UrlPattern)WireMock.urlEqualTo((String)"/patch")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxyingServiceAdmin.register(WireMock.patch((UrlPattern)WireMock.urlEqualTo((String)"/patch")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.patchWithBody("/patch", "Patch body", "text/plain", "utf-8");
        this.targetServiceAdmin.verifyThat(WireMock.patchRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/patch")).withRequestBody((ContentPattern)WireMock.equalTo((String)"Patch body")));
    }

    @Test
    public void addsSpecifiedHeadersToResponse() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/extra/headers")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/extra/headers")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().withHeader("X-Additional-Header", new String[]{"Yep"}).proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/extra/headers", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
        MatcherAssert.assertThat((Object)response.firstHeader("X-Additional-Header"), (Matcher)Matchers.is((Object)"Yep"));
    }

    @Test
    public void doesNotDuplicateCookieHeaders() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Set-Cookie", new String[]{"session=1234"})));
        this.proxyingServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/duplicate/cookies", new TestHttpHeader[0]);
        this.testClient.get("/duplicate/cookies", TestHttpHeader.withHeader("Cookie", "session=1234"));
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.targetServiceAdmin.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies"))));
        MatcherAssert.assertThat((Object)lastRequest.getHeaders().getHeader("Cookie").values().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void doesNotDuplicateConnectionHeader() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/duplicate/connection-header");
        this.testClient.get("/duplicate/connection-header", new TestHttpHeader[0]);
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.targetServiceAdmin.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/connection-header"))));
        MatcherAssert.assertThat((Object)lastRequest.getHeaders().getHeader("Connection").values().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void acceptsSelfSignedSslCertFromProxyTarget() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/ssl-cert");
        MatcherAssert.assertThat((Object)this.testClient.get("/ssl-cert", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void canProxyViaAForwardProxy() throws Exception {
        WireMockServer forwardProxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        forwardProxy.start();
        this.init(WireMockConfiguration.wireMockConfig().proxyVia(new ProxySettings("localhost", forwardProxy.port())));
        this.register200StubOnProxyAndTarget("/proxy-via");
        MatcherAssert.assertThat((Object)this.testClient.get("/proxy-via", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotAddAcceptEncodingHeaderToProxyRequest() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/no-accept-encoding-header");
        this.testClient.get("/no-accept-encoding-header", new TestHttpHeader[0]);
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.targetServiceAdmin.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no-accept-encoding-header"))));
        Assert.assertFalse((String)"Accept-Encoding header should not be present", (boolean)lastRequest.getHeaders().getHeader("Accept-Encoding").isPresent());
    }

    @Test
    public void passesMultipleValuesOfTheSameHeaderToTheTarget() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/multi-value-header");
        this.testClient.get("/multi-value-header", TestHttpHeader.withHeader("Accept", "accept1"), TestHttpHeader.withHeader("Accept", "accept2"));
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.targetServiceAdmin.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi-value-header"))));
        MatcherAssert.assertThat((Object)lastRequest.header("Accept").values(), (Matcher)Matchers.hasItems((Object[])new String[]{"accept1", "accept2"}));
    }

    @Test
    public void maintainsGZippedRequest() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.post((String)"/gzipped").willReturn(WireMock.aResponse().withStatus(201)));
        this.proxyingServiceAdmin.register(WireMock.post((String)"/gzipped").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        GzipCompressingEntity gzippedBody = new GzipCompressingEntity((HttpEntity)new StringEntity("gzipped body", ContentType.TEXT_PLAIN));
        this.testClient.post("/gzipped", (HttpEntity)gzippedBody, new TestHttpHeader[0]);
        this.targetServiceAdmin.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/gzipped")).withHeader("Content-Encoding", WireMock.containing((String)"gzip")).withRequestBody((ContentPattern)WireMock.equalTo((String)"gzipped body")));
    }

    @Test
    public void contextPathsWithoutTrailingSlashesArePreserved() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((String)"/example").willReturn(WireMock.ok()));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/example");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        this.targetServiceAdmin.verifyThat(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example")));
        this.targetServiceAdmin.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example/")));
    }

    @Test
    public void contextPathsWithTrailingSlashesArePreserved() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((String)"/example/").willReturn(WireMock.ok()));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/example/");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        this.targetServiceAdmin.verifyThat(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example/")));
        this.targetServiceAdmin.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example")));
    }

    @Test
    public void clientLibrariesTendToAddTheTrailingSlashWhenTheContextPathIsEmpty() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((String)"/").willReturn(WireMock.ok()));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse responseToRequestWithoutSlash = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port());
        MatcherAssert.assertThat((Object)responseToRequestWithoutSlash.statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse responseToRequestWithSlash = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/");
        MatcherAssert.assertThat((Object)responseToRequestWithSlash.statusCode(), (Matcher)Matchers.is((Object)200));
        this.targetServiceAdmin.verifyThat(2, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
        this.targetServiceAdmin.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"")));
    }

    @Test
    public void fixedDelaysAreAddedToProxiedResponses() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((String)"/delayed").willReturn(WireMock.ok()));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withFixedDelay(Integer.valueOf(300))));
        Stopwatch stopwatch = Stopwatch.createStarted();
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/delayed");
        stopwatch.stop();
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(300L)));
    }

    @Test
    public void chunkedDribbleDelayIsAddedToProxiedResponse() {
        this.initWithDefaultConfig();
        this.targetServiceAdmin.register(WireMock.get((String)"/chunk-delayed").willReturn(WireMock.ok()));
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withChunkedDribbleDelay(10, 300)));
        Stopwatch stopwatch = Stopwatch.createStarted();
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/chunk-delayed");
        stopwatch.stop();
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(300L)));
    }

    @Test
    public void stripsCorsHeadersFromTheTarget() {
        this.initWithDefaultConfig();
        this.proxyingServiceAdmin.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.targetServiceAdmin.register(WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/cors")).withName("Target with CORS").willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/cors", TestHttpHeader.withHeader("Origin", "http://somewhere.com"));
        Collection allowOriginHeaderValues = response.headers().get((Object)"Access-Control-Allow-Origin");
        MatcherAssert.assertThat((Object)allowOriginHeaderValues.size(), (Matcher)Matchers.is((Object)0));
    }

    private void register200StubOnProxyAndTarget(String url) {
        this.targetServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxyingServiceAdmin.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
    }
}

