/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.GlobalStubMappingTransformer;
import com.github.tomakehurst.wiremock.testsupport.NonGlobalStubMappingTransformer;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class RecordApiAcceptanceTest
extends AcceptanceTestBase {
    private WireMockServer proxyingService;
    private WireMockTestClient proxyingTestClient;
    private String proxyTargetUrl;
    private static final String DEFAULT_SNAPSHOT_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar\",                     \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar/baz\",                 \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n    ]                                                       \n}                                                             ";
    private static final String FILTER_BY_REQUEST_PATTERN_SNAPSHOT_REQUEST = "{                                                 \n    \"outputFormat\": \"full\",                   \n    \"persist\": \"false\",                       \n    \"filters\": {                                \n        \"urlPattern\": \"/foo.*\",               \n        \"headers\": {                            \n            \"A\": { \"equalTo\": \"B\" }         \n        }                                         \n    }                                             \n}                                                   ";
    private static final String FILTER_BY_REQUEST_PATTERN_SNAPSHOT_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar\",                     \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar/baz\",                 \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        }                                                   \n    ]                                                       \n}                                                             ";
    private static final String FILTER_BY_REQUEST_PATTERN_AND_IDS_SNAPSHOT_REQUEST_TEMPLATE = "{                                                     \n    \"outputFormat\": \"full\",                       \n    \"persist\": \"false\",                           \n    \"filters\": {                                    \n        \"ids\": [ \"%s\", \"%s\" ],                  \n        \"urlPattern\": \"/foo.*\"                    \n    }                                                 \n}                                                       ";
    private static final String FILTER_BY_REQUEST_PATTERN_AND_IDS_SNAPSHOT_RESPONSE = "{                                                       \n    \"mappings\": [                                     \n        {                                               \n            \"request\" : {                             \n                \"url\" : \"/foo/bar\",                 \n                \"method\" : \"GET\"                    \n            },                                          \n            \"response\" : {                            \n                \"status\" : 200                        \n            }                                           \n        }                                               \n    ]                                                   \n}                                                         ";
    private static final String FILTER_BY_WITH_NON_PROXIED_TRUE_SNAPSHOT_REQUEST = "{                                                 \n    \"persist\": false,                           \n    \"filters\": {                                \n        \"allowNonProxied\": true                 \n    }                                             \n}                                                   ";
    private static final String FILTER_BY_WITH_NON_PROXIED_TRUE_SNAPSHOT_RESPONSE = "{                                                       \n    \"mappings\": [                                     \n        {                                               \n            \"request\" : {                             \n                \"url\" : \"/record-anyway\",           \n                \"method\" : \"GET\"                    \n            },                                          \n            \"response\" : {                            \n                \"status\" : 404                        \n            }                                           \n        }                                               \n    ]                                                   \n}                                                         ";
    private static final String CAPTURE_HEADERS_SNAPSHOT_REQUEST = "{                                      \n    \"outputFormat\": \"full\",        \n    \"persist\": \"false\",            \n    \"captureHeaders\": {              \n        \"Accept\": {                  \n            \"caseInsensitive\": true  \n        },                             \n        \"X-Another\": {}              \n    }                                  \n}                                        ";
    private static final String CAPTURE_HEADERS_SNAPSHOT_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar\",                     \n                \"method\" : \"PUT\",                       \n                \"headers\": {                              \n                    \"Accept\": {                           \n                        \"equalTo\": \"text/plain\",        \n                        \"caseInsensitive\": true           \n                    },                                      \n                    \"X-Another\": {                        \n                        \"equalTo\": \"blah\"               \n                    }                                       \n                }                                           \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        }                                                   \n    ]                                                       \n}                                                             ";
    private static final String REPEATS_AS_SCENARIOS_SNAPSHOT_REQUEST = "{                                                 \n    \"outputFormat\": \"full\",                   \n    \"persist\": \"false\",                       \n    \"repeatsAsScenarios\": \"true\"              \n}                                                   ";
    private static final String REPEATS_AS_SCENARIOS_SNAPSHOT_RESPONSE = "{                                                                 \n    \"mappings\": [                                               \n        {                                                         \n            \"scenarioName\" : \"scenario-1-bar-baz\",            \n            \"requiredScenarioState\" : \"Started\",              \n            \"newScenarioState\" : \"scenario-1-bar-baz-2\",      \n            \"request\" : {                                       \n                \"url\" : \"/bar/baz\",                           \n                \"method\" : \"GET\"                              \n            }                                                     \n        },                                                        \n        {                                                         \n            \"request\" : {                                       \n                \"url\" : \"/foo\",                               \n                \"method\" : \"GET\"                              \n            }                                                     \n        },                                                        \n        {                                                         \n            \"scenarioName\" : \"scenario-1-bar-baz\",            \n            \"requiredScenarioState\" : \"scenario-1-bar-baz-2\", \n            \"request\" : {                                       \n                \"url\" : \"/bar/baz\",                           \n                \"method\" : \"GET\"                              \n            }                                                     \n        }                                                         \n    ]                                                             \n}                                                                   ";
    private static final String GLOBAL_TRANSFORMED_STUB_MAPPING_REQUEST = "{                                  \n    \"outputFormat\": \"full\",    \n    \"persist\": \"false\"         \n}                                    ";
    private static final String GLOBAL_TRANSFORMED_STUB_MAPPING_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/?transformed=global\",         \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo?transformed=global\",      \n                \"method\" : \"GET\"                        \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n    ]                                                       \n}                                                             ";
    private static final String NONGLOBAL_TRANSFORMED_STUB_MAPPING_REQUEST = "{                                    \n    \"outputFormat\": \"full\",      \n    \"persist\": \"false\",          \n    \"transformers\": [              \n       \"nonglobal-transformer\"     \n    ]                                \n}                                      ";
    private static final String NONGLOBAL_TRANSFORMED_STUB_MAPPING_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/?transformed=nonglobal\",      \n                \"method\" : \"GET\",                       \n                \"headers\": {                              \n                    \"Accept\": {                           \n                        \"equalTo\": \"B\"                  \n                    }                                       \n                }                                           \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo?transformed=nonglobal\",   \n                \"method\" : \"GET\",                       \n                \"headers\": {                              \n                    \"Accept\": {                           \n                        \"equalTo\": \"B\"                  \n                    }                                       \n                }                                           \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        }                                                   \n    ]                                                       \n}                                                             ";
    private static final String RECORD_WITH_CAPTURE_HEADERS_SNAPSHOT_REQUEST_TEMPLATE = "{                                      \n    \"targetBaseUrl\": \"%s\",         \n    \"outputFormat\": \"full\",        \n    \"persist\": \"false\",            \n    \"captureHeaders\": {              \n        \"Accept\": {                  \n            \"caseInsensitive\": true  \n        },                             \n        \"X-Another\": {}              \n    }                                  \n}                                        ";
    private static final String RECORD_WITH_CAPTURE_HEADERS_RECORD_RESPONSE = "{                                                           \n    \"mappings\": [                                         \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar\",                     \n                \"method\" : \"PUT\",                       \n                \"headers\": {                              \n                    \"Accept\": {                           \n                        \"equalTo\": \"text/plain\",        \n                        \"caseInsensitive\": true           \n                    },                                      \n                    \"X-Another\": {                        \n                        \"equalTo\": \"blah\"               \n                    }                                       \n                }                                           \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        },                                                  \n        {                                                   \n            \"request\" : {                                 \n                \"url\" : \"/foo/bar\",                     \n                \"method\" : \"PUT\",                       \n                \"headers\": {                              \n                    \"Accept\": {                           \n                        \"equalTo\": \"text/plain\",        \n                        \"caseInsensitive\": true           \n                    },                                      \n                    \"X-Another\": {                        \n                        \"equalTo\": \"blah\"               \n                    }                                       \n                }                                           \n            },                                              \n            \"response\" : {                                \n                \"status\" : 200                            \n            }                                               \n        }                                                   \n    ]                                                       \n}                                                             ";
    private static final String NOT_RECORDING_ERROR = "{                                                          \n    \"errors\": [                                          \n        {                                                  \n            \"code\": 30,                                  \n            \"title\": \"Not currently recording.\"        \n        }                                                  \n    ]                                                      \n}";

    private void proxyServerStart(WireMockConfiguration config) {
        this.proxyingService = new WireMockServer((Options)config.dynamicPort());
        this.proxyingService.start();
        this.proxyTargetUrl = "http://localhost:" + wireMockServer.port();
        this.proxyingService.stubFor(WireMock.proxyAllTo((String)this.proxyTargetUrl).withMetadata(Metadata.metadata().attr("proxy", (Object)true)));
        this.proxyingTestClient = new WireMockTestClient(this.proxyingService.port());
        wireMockServer.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
    }

    private void proxyServerStartWithEmptyFileRoot() {
        this.proxyServerStart(WireMockConfiguration.wireMockConfig().withRootDirectory("src/test/resources/empty"));
    }

    @Before
    public void clearTargetServerMappings() {
        wireMockServer.resetMappings();
    }

    @After
    public void proxyServerShutdown() {
        this.proxyingService.resetMappings();
        this.proxyingService.stop();
    }

    @Test
    public void returnsRequestsWithDefaultOptions() throws Exception {
        this.proxyServerStart(WireMockConfiguration.wireMockConfig().withRootDirectory(RecordApiAcceptanceTest.setupTempFileRoot().getAbsolutePath()));
        this.proxyingTestClient.get("/foo/bar", TestHttpHeader.withHeader("A", "B"));
        this.proxyingTestClient.get("/foo/bar/baz", TestHttpHeader.withHeader("A", "B"));
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(""), WireMatchers.equalToJson(DEFAULT_SNAPSHOT_RESPONSE, JSONCompareMode.STRICT_ORDER));
        Assert.assertEquals((long)3L, (long)this.proxyingService.getStubMappings().size());
    }

    @Test
    public void returnsFilteredRequestsWithJustRequestPatternsAndFullOutputFormat() throws Exception {
        this.proxyServerStartWithEmptyFileRoot();
        this.proxyingTestClient.get("/foo/bar", TestHttpHeader.withHeader("A", "B"));
        this.proxyingTestClient.get("/foo", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/bar", TestHttpHeader.withHeader("A", "B"));
        this.proxyingTestClient.get("/foo/", TestHttpHeader.withHeader("A", "C"));
        this.proxyingTestClient.get("/foo/bar/baz", TestHttpHeader.withHeader("A", "B"));
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(FILTER_BY_REQUEST_PATTERN_SNAPSHOT_REQUEST), WireMatchers.equalToJson(FILTER_BY_REQUEST_PATTERN_SNAPSHOT_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void returnsFilteredRequestsWithRequestPatternAndIdsWithFullOutputFormat() {
        this.proxyServerStartWithEmptyFileRoot();
        this.proxyingTestClient.get("/foo/bar", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/bar", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/foo", new TestHttpHeader[0]);
        UUID fooBarId = this.findServeEventWithRequestUrl("/foo/bar").getId();
        UUID barId = this.findServeEventWithRequestUrl("/bar").getId();
        String request = String.format(FILTER_BY_REQUEST_PATTERN_AND_IDS_SNAPSHOT_REQUEST_TEMPLATE, fooBarId, barId);
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(request), WireMatchers.equalToJson(FILTER_BY_REQUEST_PATTERN_AND_IDS_SNAPSHOT_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void returnsStubsFromNonProxiedRequestsWhenRequested() {
        this.proxyServerStartWithEmptyFileRoot();
        this.proxyingService.removeStubsByMetadata(WireMock.matchingJsonPath((String)"$.proxy"));
        this.proxyingTestClient.get("/record-anyway", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(FILTER_BY_WITH_NON_PROXIED_TRUE_SNAPSHOT_REQUEST), WireMatchers.equalToJson(FILTER_BY_WITH_NON_PROXIED_TRUE_SNAPSHOT_RESPONSE, JSONCompareMode.LENIENT));
    }

    private ServeEvent findServeEventWithRequestUrl(final String url) {
        return (ServeEvent)Iterables.find((Iterable)this.proxyingService.getAllServeEvents(), (Predicate)new Predicate<ServeEvent>(){

            public boolean apply(ServeEvent input) {
                return url.equals(input.getRequest().getUrl());
            }
        });
    }

    @Test
    public void returnsStubMappingWithCapturedHeaders() {
        this.proxyServerStartWithEmptyFileRoot();
        this.proxyingTestClient.put("/foo/bar", TestHttpHeader.withHeader("Ignored", "whatever"), TestHttpHeader.withHeader("Accept", "text/plain"), TestHttpHeader.withHeader("X-Another", "blah"));
        String actual = this.proxyingTestClient.snapshot(CAPTURE_HEADERS_SNAPSHOT_REQUEST);
        MatcherAssert.assertThat((Object)actual, WireMatchers.equalToJson(CAPTURE_HEADERS_SNAPSHOT_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void returnsStubMappingsWithScenariosForRepeatedRequests() {
        this.proxyServerStartWithEmptyFileRoot();
        this.proxyingTestClient.get("/bar/baz", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/foo", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/bar/baz", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(REPEATS_AS_SCENARIOS_SNAPSHOT_REQUEST), WireMatchers.equalToJson(REPEATS_AS_SCENARIOS_SNAPSHOT_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void returnsTransformedStubMappingWithGlobalTransformer() {
        this.proxyServerStart(WireMockConfiguration.wireMockConfig().withRootDirectory("src/test/resources/empty").extensions(new Class[]{GlobalStubMappingTransformer.class, NonGlobalStubMappingTransformer.class}));
        this.proxyingTestClient.get("/", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/foo", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(GLOBAL_TRANSFORMED_STUB_MAPPING_REQUEST), WireMatchers.equalToJson(GLOBAL_TRANSFORMED_STUB_MAPPING_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void returnsTransformedStubMappingWithNonGlobalTransformer() {
        this.proxyServerStart(WireMockConfiguration.wireMockConfig().withRootDirectory("src/test/resources/empty").extensions(new Class[]{NonGlobalStubMappingTransformer.class}));
        this.proxyingTestClient.get("/", new TestHttpHeader[0]);
        this.proxyingTestClient.get("/foo", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.proxyingTestClient.snapshot(NONGLOBAL_TRANSFORMED_STUB_MAPPING_REQUEST), WireMatchers.equalToJson(NONGLOBAL_TRANSFORMED_STUB_MAPPING_RESPONSE, JSONCompareMode.STRICT_ORDER));
    }

    @Test
    public void startsAndStopsRecording() {
        this.proxyServerStartWithEmptyFileRoot();
        String requestJson = String.format(RECORD_WITH_CAPTURE_HEADERS_SNAPSHOT_REQUEST_TEMPLATE, this.proxyTargetUrl);
        this.proxyingTestClient.postJson("/__admin/recordings/start", requestJson, new TestHttpHeader[0]);
        this.proxyingTestClient.put("/foo/bar", TestHttpHeader.withHeader("Ignored", "whatever"), TestHttpHeader.withHeader("Accept", "text/plain"), TestHttpHeader.withHeader("X-Another", "blah"));
        this.proxyingTestClient.put("/foo/bar", TestHttpHeader.withHeader("Accept", "text/plain"), TestHttpHeader.withHeader("X-Another", "blah"));
        WireMockResponse response = this.proxyingTestClient.post("/__admin/recordings/stop", (HttpEntity)new StringEntity("", Charsets.UTF_8), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalToJson(RECORD_WITH_CAPTURE_HEADERS_RECORD_RESPONSE, JSONCompareMode.STRICT_ORDER));
        StubMapping createdMapping = WireMatchers.findMappingWithUrl(this.proxyingService.getStubMappings(), "/foo/bar");
        MatcherAssert.assertThat((Object)createdMapping.getScenarioName(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void returnsErrorWhenAttemptingToStopRecordingWhenNotStarted() {
        this.proxyServerStartWithEmptyFileRoot();
        WireMockResponse response = this.proxyingTestClient.postWithBody("/__admin/recordings/stop", "", "text/plain", "utf-8");
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalToJson(NOT_RECORDING_ERROR));
    }
}

