/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.recording.NotRecordingException;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatus;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class RecordingDslAcceptanceTest
extends AcceptanceTestBase {
    private WireMockServer targetService;
    private WireMockServer proxyingService;
    private WireMockTestClient client;
    private WireMock adminClient;
    private String targetBaseUrl;
    private File fileRoot;
    static final String IMAGE_CONTENT_BASE64 = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAPCAYAAACFgM0XAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAB3RJTUUH4AYeEQ8RFdqRVAAAA/VJREFUOMvFk9+LVHUYxj/v9/yYmbVVN1NKDVvDH6yBiuiWrG6LelG33lQQ1EVIUNA/YBARRNHVFgRWF93URV4VJGQm/l5KFNfaQNnN1a3NH+vOzM6cOed8v9+3i5mdGcLb6IUDhwfe532+D88D//PIpi8n3pIwDFAENPNp42huzMy0tdHauPBCjPYDihgkin/wNr8wdfxrYfvIcy6It7zoT8moOxLHWBfi0AVz+ePDh75/86NPwWgf8BLQiyBY+cPPmm8w5A99MAVAKGH4ikSFrQCoqnhfy4Pwc5fMrUniwjs9xSX9SFvv+sFt/WOTMzuXShQfliB6esD9Sa8keAx48HU5+/prn51DKUvIIPAhUALwVZnSRC4QMLXIaNTZb0G1yS8iQbD31t4nEZFttTxd61BAWh87r0zMPkJc2qAm2NTHAsP+alufWgHLFrPcD2hFAPYtHkdBG/K4FHVQIqUjIEuP4f29DhLs3Pjd2KMiMpQ5F6XWdgyAfuvsFoJwl5egb0Bvsllv4pGmvgwIWC5FHTar3TJguL1pASWUkh4INzhTe/eJ5jlXnRtX78bbJhuzLotLe4BBr0rd5nT00uOc3U8QDAPs9eMso9aKD2guSKxIUYfJZDewaXFRc0EChRK7fVUek0KT1fQOjlTU2p+6ctljlVdFdbMCSZ7htSMhz/ODxoRDS0kY1vGOO761XVAosR3hELC0veiAAkhR+yXWHVJQ5kfXYJJrE2iensT7KqqQ5eRODyCyQoDUWTJnmwqsJUuzzc6EqzfoDE/5G037AXV4CRSKIKGuAp6nW5w0xUmkBQz7I2OICTCuMoevV66qsxPkFl9PaDgXait1XrVsbX4e69B6gyTLUGDI/8oKKk37QRHOUaAqkYIgQNRV92lC7km8yMqeHL9SAJP9NUXfrqH7Wq+f1FqdvJaQtt8FCr8Fzo9qPam5WkKijh5SRvQKwaLvUJeAIxLrZHdiO8HmqMQ6hmkjG4GtAGb6vZeZPzuGmy+f8OWFJM0yrHRYBM6UGva4VmrXs6RBQwz9Oss2nWx2f/GFwo8IFx9wvgEcw3CqC+sBRgSaDHb2Fu7u7Ut+vnwtwaOd+wlw4lpl7q6Wq6cbLscZwzP6O6v0fpdP/CLCDHCmE8f23ACuAOeBhS78WYWHDYC7M8vk+wdv59WF043I0GXjdeDSykqKrSwcr4cmLZCxz18mwrUbBpxqFeVn4M6/BFxUuA1MAJNd+ACwIwSY/uIN+t4+Rlgpf2VFi2S5iGLUmPPau+ROKkpeii404uCTFfl83zr/t9aJfSwub1l8okU6CYwC6zvZ56iAV7gn8DGwo1VKAHlQZP7zSUbXtf//AaFX9LL7Nh3cAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE2LTA2LTMwVDE3OjE1OjE3KzAxOjAwsKT/BwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNi0wNi0zMFQxNzoxNToxNyswMTowMMH5R7sAAAAASUVORK5CYII=";

    @Override
    public void init() {
        this.fileRoot = RecordingDslAcceptanceTest.setupTempFileRoot();
        this.proxyingService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().withRootDirectory(this.fileRoot.getAbsolutePath()));
        this.proxyingService.start();
        this.targetService = wireMockServer;
        this.targetBaseUrl = "http://localhost:" + this.targetService.port();
        this.client = new WireMockTestClient(this.proxyingService.port());
        WireMock.configureFor((int)this.proxyingService.port());
        this.adminClient = WireMock.create().port(this.proxyingService.port()).build();
    }

    @After
    public void proxyServerShutdown() {
        this.proxyingService.resetMappings();
        this.proxyingService.stop();
    }

    @Test
    public void startsRecordingWithDefaultSpecFromTheSpecifiedProxyBaseUrlWhenServeEventsAlreadyExist() {
        this.targetService.stubFor(WireMock.get((String)"/record-this").willReturn(WireMock.okForContentType((String)"text/plain", (String)"Got it")));
        this.targetService.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/do-not-record-this/.*")).willReturn(WireMock.noContent()));
        this.client.get("/do-not-record-this/1", new TestHttpHeader[0]);
        this.client.get("/do-not-record-this/2", new TestHttpHeader[0]);
        this.client.get("/do-not-record-this/3", new TestHttpHeader[0]);
        WireMock.startRecording((String)this.targetBaseUrl);
        this.client.get("/record-this", new TestHttpHeader[0]);
        List returnedMappings = WireMock.stopRecording().getStubMappings();
        this.client.get("/do-not-record-this/4", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/record-this"));
        StubMapping mapping = WireMatchers.findMappingWithUrl(this.proxyingService.getStubMappings(), "/record-this");
        MatcherAssert.assertThat((Object)mapping.getResponse().getBody(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void generatesStubNameFromUrlPath() {
        this.targetService.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/record-this/.*")).willReturn(WireMock.ok((String)"Fine")));
        WireMock.startRecording((String)this.targetBaseUrl);
        String url = "/record-this/with$!/safe/\u0143aMe?ignore=this";
        this.client.get(url, new TestHttpHeader[0]);
        List mappings = WireMock.stopRecording().getStubMappings();
        StubMapping mapping = (StubMapping)mappings.get(0);
        MatcherAssert.assertThat((Object)mapping.getName(), (Matcher)Matchers.is((Object)"record-this_with_safe_name"));
    }

    @Test
    public void startsRecordingWithDefaultSpecFromTheSpecifiedProxyBaseUrlWhenNoServeEventsAlreadyExist() {
        this.targetService.stubFor(WireMock.get((String)"/record-this").willReturn(WireMock.okForContentType((String)"text/plain", (String)"Got it")));
        WireMock.startRecording((String)this.targetBaseUrl);
        this.client.get("/record-this", new TestHttpHeader[0]);
        List returnedMappings = WireMock.stopRecording().getStubMappings();
        MatcherAssert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/record-this"));
        StubMapping mapping = WireMatchers.findMappingWithUrl(this.proxyingService.getStubMappings(), "/record-this");
        MatcherAssert.assertThat((Object)mapping.getResponse().getBody(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void recordsNothingWhenNoServeEventsAreRecievedDuringRecording() {
        this.targetService.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/do-not-record-this/.*")).willReturn(WireMock.noContent()));
        this.client.get("/do-not-record-this/1", new TestHttpHeader[0]);
        this.client.get("/do-not-record-this/2", new TestHttpHeader[0]);
        WireMock.startRecording((String)this.targetBaseUrl);
        List returnedMappings = WireMock.stopRecording().getStubMappings();
        this.client.get("/do-not-record-this/3", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.proxyingService.getStubMappings(), (Matcher)Matchers.empty());
    }

    @Test
    public void recordsNothingWhenNoServeEventsAreRecievedAtAll() {
        WireMock.startRecording((String)this.targetBaseUrl);
        List returnedMappings = WireMock.stopRecording().getStubMappings();
        MatcherAssert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.proxyingService.getStubMappings(), (Matcher)Matchers.empty());
    }

    @Test
    public void honoursRecordSpecWhenPresent() {
        this.targetService.stubFor(WireMock.get((String)"/record-this-with-header").willReturn(WireMock.ok()));
        WireMock.startRecording((RecordSpecBuilder)WireMock.recordSpec().forTarget(this.targetBaseUrl).captureHeader("Accept"));
        this.client.get("/record-this", TestHttpHeader.withHeader("Accept", "text/plain"));
        List returnedMappings = WireMock.stopRecording().getStubMappings();
        MatcherAssert.assertThat((Object)((MultiValuePattern)((StubMapping)returnedMappings.get(0)).getRequest().getHeaders().get("Accept")).getExpected(), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void supportsInstanceClientWithDefaultSpec() {
        this.targetService.stubFor(WireMock.get((String)"/record-this").willReturn(WireMock.okForContentType((String)"text/plain", (String)"Got it")));
        this.adminClient.startStubRecording(this.targetBaseUrl);
        this.client.get("/record-this", new TestHttpHeader[0]);
        List returnedMappings = this.adminClient.stopStubRecording().getStubMappings();
        MatcherAssert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/record-this"));
        StubMapping mapping = WireMatchers.findMappingWithUrl(this.proxyingService.getStubMappings(), "/record-this");
        MatcherAssert.assertThat((Object)mapping.getResponse().getBody(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void supportsInstanceClientWithSpec() {
        this.targetService.stubFor(WireMock.post((String)"/record-this-with-body").willReturn(WireMock.ok()));
        this.adminClient.startStubRecording(WireMock.recordSpec().forTarget(this.targetBaseUrl).matchRequestBodyWithEqualToJson(Boolean.valueOf(true), Boolean.valueOf(true)));
        this.client.postJson("/record-this-with-body", "{}", new TestHttpHeader[0]);
        List returnedMappings = this.adminClient.stopStubRecording().getStubMappings();
        EqualToJsonPattern bodyPattern = (EqualToJsonPattern)((StubMapping)returnedMappings.get(0)).getRequest().getBodyPatterns().get(0);
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsDirectDslCallsWithSpec() {
        this.targetService.stubFor(WireMock.post((String)"/record-this-with-body").willReturn(WireMock.ok()));
        this.proxyingService.startRecording(WireMock.recordSpec().forTarget(this.targetBaseUrl).matchRequestBodyWithEqualToJson(Boolean.valueOf(true), Boolean.valueOf(true)));
        this.client.postJson("/record-this-with-body", "{}", new TestHttpHeader[0]);
        List returnedMappings = this.proxyingService.stopRecording().getStubMappings();
        EqualToJsonPattern bodyPattern = (EqualToJsonPattern)((StubMapping)returnedMappings.get(0)).getRequest().getBodyPatterns().get(0);
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bodyPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsTheRecordingStatus() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        RecordingStatusResult result = WireMock.getRecordingStatus();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.is((Object)RecordingStatus.Recording));
    }

    @Test
    public void returnsTheRecordingStatusViaInstanceClient() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        this.proxyingService.stopRecording();
        RecordingStatusResult result = this.adminClient.getStubRecordingStatus();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.is((Object)RecordingStatus.Stopped));
    }

    @Test
    public void returnsTheRecordingStatusViaDirectDsl() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        RecordingStatusResult result = this.proxyingService.getRecordingStatus();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.is((Object)RecordingStatus.Recording));
    }

    @Test
    public void recordsIntoPlainTextWhenRequestIsGZipped() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        this.targetService.stubFor(WireMock.post((String)"/gzipped").willReturn(WireMock.ok((String)"Zippy")));
        GzipCompressingEntity compressedBody = new GzipCompressingEntity((HttpEntity)new StringEntity("expected body", ContentType.TEXT_PLAIN));
        this.client.post("/gzipped", (HttpEntity)compressedBody, new TestHttpHeader[0]);
        StubMapping mapping = (StubMapping)this.proxyingService.stopRecording().getStubMappings().get(0);
        MatcherAssert.assertThat((Object)((ContentPattern)mapping.getRequest().getBodyPatterns().get(0)).getExpected(), (Matcher)Matchers.is((Object)"expected body"));
    }

    @Test
    public void recordsIntoPlainTextWhenResponseIsGZipped() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        byte[] gzippedBody = Gzip.gzip((String)"Zippy");
        this.targetService.stubFor(WireMock.get((String)"/gzipped-response").willReturn(WireMock.aResponse().withHeader("Content-Encoding", new String[]{"gzip"}).withHeader("Content-Type", new String[]{"text/plain"}).withBody(gzippedBody)));
        this.client.get("/gzipped-response", new TestHttpHeader[0]);
        StubMapping mapping = (StubMapping)this.proxyingService.stopRecording().getStubMappings().get(0);
        MatcherAssert.assertThat((Object)mapping.getResponse().getBody(), (Matcher)Matchers.is((Object)"Zippy"));
    }

    @Test
    public void recordsIntoPlainBinaryWhenResponseIsGZipped() {
        this.proxyingService.startRecording(this.targetBaseUrl);
        byte[] originalBody = "sdkfnslkdjfsjdf".getBytes(Strings.DEFAULT_CHARSET);
        byte[] gzippedBody = Gzip.gzip((byte[])originalBody);
        this.targetService.stubFor(WireMock.get((String)"/gzipped-response").willReturn(WireMock.aResponse().withHeader("Content-Encoding", new String[]{"gzip"}).withHeader("Content-Type", new String[]{ContentType.APPLICATION_OCTET_STREAM.getMimeType()}).withBody(gzippedBody)));
        this.client.get("/gzipped-response", new TestHttpHeader[0]);
        StubMapping mapping = (StubMapping)this.proxyingService.stopRecording().getStubMappings().get(0);
        MatcherAssert.assertThat((Object)mapping.getResponse().getByteBody(), (Matcher)Matchers.is((Object)originalBody));
    }

    @Test
    public void defaultsToWritingBinaryResponseFilesOfAnySize() {
        this.targetService.stubFor(WireMock.get((String)"/myimage.png").willReturn(WireMock.aResponse().withBase64Body(IMAGE_CONTENT_BASE64)));
        this.proxyingService.startRecording(WireMock.recordSpec().forTarget(this.targetBaseUrl));
        this.client.get("/myimage.png", new TestHttpHeader[0]);
        List mappings = this.proxyingService.stopRecording().getStubMappings();
        StubMapping mapping = (StubMapping)mappings.get(0);
        String bodyFileName = mapping.getResponse().getBodyFileName();
        MatcherAssert.assertThat((Object)bodyFileName, (Matcher)Matchers.is((Object)("myimagepng-" + mapping.getId() + ".png")));
        File bodyFile = new File(this.fileRoot, "__files/" + bodyFileName);
        MatcherAssert.assertThat((Object)bodyFile.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToWritingTextResponseFilesOver1Kb() {
        this.targetService.stubFor(WireMock.get((String)"/large.txt").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody(StringUtils.rightPad((String)"", (int)10241, (char)'a'))));
        this.proxyingService.startRecording(WireMock.recordSpec().forTarget(this.targetBaseUrl));
        this.client.get("/large.txt", new TestHttpHeader[0]);
        List mappings = this.proxyingService.stopRecording().getStubMappings();
        StubMapping mapping = (StubMapping)mappings.get(0);
        String bodyFileName = mapping.getResponse().getBodyFileName();
        MatcherAssert.assertThat((Object)bodyFileName, (Matcher)Matchers.is((Object)("largetxt-" + mapping.getId() + ".txt")));
        File bodyFile = new File(this.fileRoot, "__files/" + bodyFileName);
        MatcherAssert.assertThat((Object)bodyFile.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void doesNotWriteTextResponseFilesUnder1KbByDefault() {
        this.targetService.stubFor(WireMock.get((String)"/small.txt").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody(StringUtils.rightPad((String)"", (int)10239, (char)'a'))));
        this.proxyingService.startRecording(WireMock.recordSpec().forTarget(this.targetBaseUrl));
        this.client.get("/small.txt", new TestHttpHeader[0]);
        List mappings = this.proxyingService.stopRecording().getStubMappings();
        String bodyFileName = ((StubMapping)mappings.get(0)).getResponse().getBodyFileName();
        MatcherAssert.assertThat((Object)bodyFileName, (Matcher)Matchers.nullValue());
    }

    @Test(expected=NotRecordingException.class)
    public void throwsAnErrorIfAttemptingToStopViaStaticRemoteDslWhenNotRecording() {
        WireMock.stopRecording();
    }

    @Test(expected=NotRecordingException.class)
    public void throwsAnErrorIfAttemptingToStopViaInstanceRemoteDslWhenNotRecording() {
        this.adminClient.stopStubRecording();
    }

    @Test(expected=NotRecordingException.class)
    public void throwsAnErrorIfAttemptingToStopViaDirectDslWhenNotRecording() {
        this.proxyingService.stopRecording();
    }

    @Test(expected=InvalidInputException.class)
    public void throwsValidationErrorWhenAttemptingToStartRecordingViaStaticDslWithNoTargetUrl() {
        WireMock.startRecording((RecordSpecBuilder)WireMock.recordSpec());
    }

    @Test(expected=InvalidInputException.class)
    public void throwsValidationErrorWhenAttemptingToStartRecordingViaDirectDslWithNoTargetUrl() {
        this.proxyingService.startRecording(WireMock.recordSpec());
    }
}

