/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RemoveStubMappingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void removeStubThatExistsUsingUUID() {
        UUID id1 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-1")).withId(id1).willReturn(WireMock.aResponse().withBody("Stub-1-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-1", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-1-Body"));
        UUID id2 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-2")).withId(id2).willReturn(WireMock.aResponse().withBody("Stub-2-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-2", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-2-Body"));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-1", "/stub-2"), (Matcher)Matchers.is((Object)2));
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-2")).withId(id2).willReturn(WireMock.aResponse().withBody("Stub-2-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-1", "/stub-2"), (Matcher)Matchers.is((Object)1));
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-1")).withId(id1).willReturn(WireMock.aResponse().withBody("Stub-1-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-1", "/stub-2"), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void removeStubThatExistsUsingRequestMatchUUIDNotMatch() {
        UUID id1 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-11")).withId(id1).willReturn(WireMock.aResponse().withBody("Stub-11-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-11", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-11-Body"));
        UUID id2 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-22")).withId(id2).willReturn(WireMock.aResponse().withBody("Stub-22-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-22", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-22-Body"));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-11", "/stub-22"), (Matcher)Matchers.is((Object)2));
        UUID id3 = UUID.randomUUID();
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-22")).withId(id3).willReturn(WireMock.aResponse().withBody("Stub-22-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-11", "/stub-22"), (Matcher)Matchers.is((Object)1));
        UUID id4 = UUID.randomUUID();
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-11")).withId(id4).willReturn(WireMock.aResponse().withBody("Stub-11-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-11", "/stub-22"), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void removeStubThatExistsWithRequestMatchNoUUIDPresent() {
        UUID id1 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-111")).withId(id1).willReturn(WireMock.aResponse().withBody("Stub-111-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-111", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-111-Body"));
        UUID id2 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-222")).withId(id2).willReturn(WireMock.aResponse().withBody("Stub-222-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stub-222", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stub-222-Body"));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-111", "/stub-222"), (Matcher)Matchers.is((Object)2));
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-222")).willReturn(WireMock.aResponse().withBody("Stub-222-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-111", "/stub-222"), (Matcher)Matchers.is((Object)1));
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub-111")).willReturn(WireMock.aResponse().withBody("Stub-111-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stub-111", "/stub-222"), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void removeStubThatDoesNotExists() {
        UUID id1 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stb-1")).withId(id1).willReturn(WireMock.aResponse().withBody("Stb-1-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stb-1", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stb-1-Body"));
        UUID id2 = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stb-2")).withId(id2).willReturn(WireMock.aResponse().withBody("Stb-2-Body")));
        MatcherAssert.assertThat((Object)testClient.get("/stb-2", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Stb-2-Body"));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stb-1", "/stb-2"), (Matcher)Matchers.is((Object)2));
        UUID id3 = UUID.randomUUID();
        WireMock.removeStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stb-3")).withId(id3).willReturn(WireMock.aResponse().withBody("Stb-3-Body")));
        MatcherAssert.assertThat((Object)this.getMatchingStubCount("/stb-1", "/stb-2"), (Matcher)Matchers.is((Object)2));
    }

    private Predicate<StubMapping> withAnyOf(final String ... urls) {
        return new Predicate<StubMapping>(){

            public boolean apply(StubMapping mapping) {
                return mapping.getRequest().getUrl() != null && Arrays.asList(urls).contains(mapping.getRequest().getUrl());
            }
        };
    }

    private synchronized int getMatchingStubCount(String url1, String url2) {
        return FluentIterable.from((Iterable)WireMock.listAllStubMappings().getMappings()).filter(this.withAnyOf(url1, url2)).size();
    }
}

